/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.modbus.config.ModbusConfiguration;
import org.apache.plc4x.java.modbus.field.ModbusField;
import org.apache.plc4x.java.modbus.field.ModbusFieldHandler;
import org.apache.plc4x.java.modbus.protocol.ModbusProtocolLogic;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.modbus.readwrite.io.ModbusTcpADUIO;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleFieldOptimizer;

public class ModbusDriver
extends GeneratedDriverBase<ModbusTcpADU> {
    public String getProtocolCode() {
        return "modbus";
    }

    public String getProtocolName() {
        return "Modbus";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return ModbusConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleFieldOptimizer();
    }

    protected ModbusFieldHandler getFieldHandler() {
        return new ModbusFieldHandler();
    }

    protected ProtocolStackConfigurer<ModbusTcpADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusTcpADU.class, ModbusTcpADUIO.class).withProtocol(ModbusProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{true}).build();
    }

    public ModbusField prepareField(String query) {
        return ModbusField.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4) + 6;
            }
            return -1;
        }
    }
}

