/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite.io;

import org.apache.plc4x.java.abeth.readwrite.DF1CommandResponseMessageProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.readwrite.DF1ResponseMessage;
import org.apache.plc4x.java.abeth.readwrite.io.DF1CommandResponseMessageProtectedTypedLogicalReadIO;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DF1ResponseMessageIO
implements MessageIO<DF1ResponseMessage, DF1ResponseMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DF1ResponseMessageIO.class);

    public DF1ResponseMessage parse(ReadBuffer io, Object ... args) throws ParseException {
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (!(args[0] instanceof Integer)) {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer but was " + args[0].getClass().getName());
        }
        Integer payloadLength = (Integer)args[0];
        return DF1ResponseMessageIO.staticParse(io, payloadLength);
    }

    public void serialize(WriteBuffer io, DF1ResponseMessage value, Object ... args) throws ParseException {
        DF1ResponseMessageIO.staticSerialize(io, value);
    }

    public static DF1ResponseMessage staticParse(ReadBuffer io, Integer payloadLength) throws ParseException {
        int startPos = io.getPos();
        short reserved = io.readUnsignedShort(8);
        if (reserved != 0) {
            LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
        }
        short destinationAddress = io.readUnsignedShort(8);
        short sourceAddress = io.readUnsignedShort(8);
        short reserved2 = io.readUnsignedShort(8);
        if (reserved2 != 0) {
            LOGGER.info("Expected constant value 0 but got " + reserved2 + " for reserved field.");
        }
        short commandCode = io.readUnsignedShort(8);
        short status = io.readUnsignedShort(8);
        int transactionCounter = io.readUnsignedInt(16);
        DF1CommandResponseMessageProtectedTypedLogicalReadIO.DF1CommandResponseMessageProtectedTypedLogicalReadBuilder builder = null;
        if (EvaluationHelper.equals((Object)commandCode, (Object)79)) {
            builder = DF1CommandResponseMessageProtectedTypedLogicalReadIO.staticParse(io, payloadLength, status);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type");
        }
        return builder.build(destinationAddress, sourceAddress, status, transactionCounter);
    }

    public static void staticSerialize(WriteBuffer io, DF1ResponseMessage _value) throws ParseException {
        int startPos = io.getPos();
        io.writeUnsignedShort(8, ((Number)0).shortValue());
        short destinationAddress = _value.getDestinationAddress();
        io.writeUnsignedShort(8, ((Number)destinationAddress).shortValue());
        short sourceAddress = _value.getSourceAddress();
        io.writeUnsignedShort(8, ((Number)sourceAddress).shortValue());
        io.writeUnsignedShort(8, ((Number)0).shortValue());
        short commandCode = _value.getCommandCode();
        io.writeUnsignedShort(8, ((Number)commandCode).shortValue());
        short status = _value.getStatus();
        io.writeUnsignedShort(8, ((Number)status).shortValue());
        int transactionCounter = _value.getTransactionCounter();
        io.writeUnsignedInt(16, ((Number)transactionCounter).intValue());
        if (_value instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
            DF1CommandResponseMessageProtectedTypedLogicalReadIO.staticSerialize(io, (DF1CommandResponseMessageProtectedTypedLogicalRead)_value);
        }
    }

    public static interface DF1ResponseMessageBuilder {
        public DF1ResponseMessage build(short var1, short var2, short var3, int var4);
    }
}

