/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite.io;

import org.apache.plc4x.java.abeth.readwrite.DF1CommandRequestMessage;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestMessage;
import org.apache.plc4x.java.abeth.readwrite.io.DF1CommandRequestMessageIO;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DF1RequestMessageIO
implements MessageIO<DF1RequestMessage, DF1RequestMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DF1RequestMessageIO.class);

    public DF1RequestMessage parse(ReadBuffer io, Object ... args) throws ParseException {
        return DF1RequestMessageIO.staticParse(io);
    }

    public void serialize(WriteBuffer io, DF1RequestMessage value, Object ... args) throws ParseException {
        DF1RequestMessageIO.staticSerialize(io, value);
    }

    public static DF1RequestMessage staticParse(ReadBuffer io) throws ParseException {
        int startPos = io.getPos();
        short destinationAddress = io.readUnsignedShort(8);
        short sourceAddress = io.readUnsignedShort(8);
        int reserved = io.readUnsignedInt(16);
        if (reserved != 0) {
            LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
        }
        short commandCode = io.readUnsignedShort(8);
        short status = io.readUnsignedShort(8);
        int transactionCounter = io.readUnsignedInt(16);
        DF1CommandRequestMessageIO.DF1CommandRequestMessageBuilder builder = null;
        if (EvaluationHelper.equals((Object)commandCode, (Object)15)) {
            builder = DF1CommandRequestMessageIO.staticParse(io);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type");
        }
        return builder.build(destinationAddress, sourceAddress, status, transactionCounter);
    }

    public static void staticSerialize(WriteBuffer io, DF1RequestMessage _value) throws ParseException {
        int startPos = io.getPos();
        short destinationAddress = _value.getDestinationAddress();
        io.writeUnsignedShort(8, ((Number)destinationAddress).shortValue());
        short sourceAddress = _value.getSourceAddress();
        io.writeUnsignedShort(8, ((Number)sourceAddress).shortValue());
        io.writeUnsignedInt(16, ((Number)0).intValue());
        short commandCode = _value.getCommandCode();
        io.writeUnsignedShort(8, ((Number)commandCode).shortValue());
        short status = _value.getStatus();
        io.writeUnsignedShort(8, ((Number)status).shortValue());
        int transactionCounter = _value.getTransactionCounter();
        io.writeUnsignedInt(16, ((Number)transactionCounter).intValue());
        if (_value instanceof DF1CommandRequestMessage) {
            DF1CommandRequestMessageIO.staticSerialize(io, (DF1CommandRequestMessage)_value);
        }
    }

    public static interface DF1RequestMessageBuilder {
        public DF1RequestMessage build(short var1, short var2, short var3, int var4);
    }
}

