/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite.io;

import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationConnectionRequestIO;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationConnectionResponseIO;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationReadRequestIO;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationReadResponseIO;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CIPEncapsulationPacketIO
implements MessageIO<CIPEncapsulationPacket, CIPEncapsulationPacket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CIPEncapsulationPacketIO.class);

    public CIPEncapsulationPacket parse(ReadBuffer io, Object ... args) throws ParseException {
        return CIPEncapsulationPacketIO.staticParse(io);
    }

    public void serialize(WriteBuffer io, CIPEncapsulationPacket value, Object ... args) throws ParseException {
        CIPEncapsulationPacketIO.staticSerialize(io, value);
    }

    public static CIPEncapsulationPacket staticParse(ReadBuffer io) throws ParseException {
        int startPos = io.getPos();
        int commandType = io.readUnsignedInt(16);
        int len = io.readUnsignedInt(16);
        long sessionHandle = io.readUnsignedLong(32);
        long status = io.readUnsignedLong(32);
        int itemCount = 8;
        short[] senderContext = new short[itemCount];
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            senderContext[curItem] = io.readUnsignedShort(8);
        }
        long options = io.readUnsignedLong(32);
        long reserved = io.readUnsignedLong(32);
        if (reserved != 0L) {
            LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
        }
        CIPEncapsulationPacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)commandType, (Object)257)) {
            builder = CIPEncapsulationConnectionRequestIO.staticParse(io);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)513)) {
            builder = CIPEncapsulationConnectionResponseIO.staticParse(io);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)263)) {
            builder = CIPEncapsulationReadRequestIO.staticParse(io);
        } else if (EvaluationHelper.equals((Object)commandType, (Object)519)) {
            builder = CIPEncapsulationReadResponseIO.staticParse(io, len);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type");
        }
        return builder.build(sessionHandle, status, senderContext, options);
    }

    public static void staticSerialize(WriteBuffer io, CIPEncapsulationPacket _value) throws ParseException {
        int startPos = io.getPos();
        int commandType = _value.getCommandType();
        io.writeUnsignedInt(16, ((Number)commandType).intValue());
        int len = _value.getLengthInBytes() - 28;
        io.writeUnsignedInt(16, ((Number)len).intValue());
        long sessionHandle = _value.getSessionHandle();
        io.writeUnsignedLong(32, ((Number)sessionHandle).longValue());
        long status = _value.getStatus();
        io.writeUnsignedLong(32, ((Number)status).longValue());
        if (_value.getSenderContext() != null) {
            int itemCount = _value.getSenderContext().length;
            int curItem = 0;
            for (short element : _value.getSenderContext()) {
                io.writeUnsignedShort(8, ((Number)element).shortValue());
                ++curItem;
            }
        }
        long options = _value.getOptions();
        io.writeUnsignedLong(32, ((Number)options).longValue());
        io.writeUnsignedLong(32, ((Number)0L).longValue());
        if (_value instanceof CIPEncapsulationConnectionRequest) {
            CIPEncapsulationConnectionRequestIO.staticSerialize(io, (CIPEncapsulationConnectionRequest)_value);
        } else if (_value instanceof CIPEncapsulationConnectionResponse) {
            CIPEncapsulationConnectionResponseIO.staticSerialize(io, (CIPEncapsulationConnectionResponse)_value);
        } else if (_value instanceof CIPEncapsulationReadRequest) {
            CIPEncapsulationReadRequestIO.staticSerialize(io, (CIPEncapsulationReadRequest)_value);
        } else if (_value instanceof CIPEncapsulationReadResponse) {
            CIPEncapsulationReadResponseIO.staticSerialize(io, (CIPEncapsulationReadResponse)_value);
        }
    }

    public static interface CIPEncapsulationPacketBuilder {
        public CIPEncapsulationPacket build(long var1, long var3, short[] var5, long var6);
    }
}

