/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.abeth.readwrite.io.DF1ResponseMessageIO;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public abstract class DF1ResponseMessage
implements Message {
    private final short destinationAddress;
    private final short sourceAddress;
    private final short status;
    private final int transactionCounter;

    public abstract Short getCommandCode();

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DF1ResponseMessage(@JsonProperty(value="destinationAddress") short destinationAddress, @JsonProperty(value="sourceAddress") short sourceAddress, @JsonProperty(value="status") short status, @JsonProperty(value="transactionCounter") int transactionCounter) {
        this.destinationAddress = destinationAddress;
        this.sourceAddress = sourceAddress;
        this.status = status;
        this.transactionCounter = transactionCounter;
    }

    public short getDestinationAddress() {
        return this.destinationAddress;
    }

    public short getSourceAddress() {
        return this.sourceAddress;
    }

    public short getStatus() {
        return this.status;
    }

    public int getTransactionCounter() {
        return this.transactionCounter;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 16;
    }

    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("destinationAddress", PlcValues.of((short)this.destinationAddress));
        fieldValues.put("sourceAddress", PlcValues.of((short)this.sourceAddress));
        fieldValues.put("status", PlcValues.of((short)this.status));
        fieldValues.put("transactionCounter", PlcValues.of((int)this.transactionCounter));
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<DF1ResponseMessage, DF1ResponseMessage> getMessageIO() {
        return new DF1ResponseMessageIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DF1ResponseMessage)) {
            return false;
        }
        DF1ResponseMessage that = (DF1ResponseMessage)o;
        return this.getDestinationAddress() == that.getDestinationAddress() && this.getSourceAddress() == that.getSourceAddress() && this.getStatus() == that.getStatus() && this.getTransactionCounter() == that.getTransactionCounter();
    }

    public int hashCode() {
        return Objects.hash(this.getDestinationAddress(), this.getSourceAddress(), this.getStatus(), this.getTransactionCounter());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("destinationAddress", this.getDestinationAddress()).append("sourceAddress", this.getSourceAddress()).append("status", this.getStatus()).append("transactionCounter", this.getTransactionCounter()).toString();
    }
}

