/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.abeth.readwrite.DF1ResponseMessage;
import org.apache.plc4x.java.abeth.readwrite.io.DF1ResponseMessageIO;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DF1CommandResponseMessageProtectedTypedLogicalRead
extends DF1ResponseMessage
implements Message {
    private final short[] data;

    @Override
    @JsonIgnore
    public Short getCommandCode() {
        return (short)79;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DF1CommandResponseMessageProtectedTypedLogicalRead(@JsonProperty(value="destinationAddress") short destinationAddress, @JsonProperty(value="sourceAddress") short sourceAddress, @JsonProperty(value="status") short status, @JsonProperty(value="transactionCounter") int transactionCounter, @JsonProperty(value="data") short[] data) {
        super(destinationAddress, sourceAddress, status, transactionCounter);
        this.data = data;
    }

    public short[] getData() {
        return this.data;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        return lengthInBits += 8 * this.data.length;
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcList> fieldValues = new TreeMap<String, PlcList>();
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.data.length);
        for (short item : this.data) {
            plcValues.add(PlcValues.of((short)item));
        }
        fieldValues.put("data", new PlcList(plcValues));
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<DF1ResponseMessage, DF1ResponseMessage> getMessageIO() {
        return new DF1ResponseMessageIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DF1CommandResponseMessageProtectedTypedLogicalRead)) {
            return false;
        }
        DF1CommandResponseMessageProtectedTypedLogicalRead that = (DF1CommandResponseMessageProtectedTypedLogicalRead)o;
        return this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getData());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("data", this.getData()).toString();
    }
}

