/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestCommand;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestMessage;
import org.apache.plc4x.java.abeth.readwrite.io.DF1RequestMessageIO;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DF1CommandRequestMessage
extends DF1RequestMessage
implements Message {
    private final DF1RequestCommand command;

    @Override
    @JsonIgnore
    public Short getCommandCode() {
        return (short)15;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DF1CommandRequestMessage(@JsonProperty(value="destinationAddress") short destinationAddress, @JsonProperty(value="sourceAddress") short sourceAddress, @JsonProperty(value="status") short status, @JsonProperty(value="transactionCounter") int transactionCounter, @JsonProperty(value="command") DF1RequestCommand command) {
        super(destinationAddress, sourceAddress, status, transactionCounter);
        this.command = command;
    }

    public DF1RequestCommand getCommand() {
        return this.command;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        return lengthInBits += this.command.getLengthInBits();
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("command", this.command.toPlcValue());
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<DF1RequestMessage, DF1RequestMessage> getMessageIO() {
        return new DF1RequestMessageIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DF1CommandRequestMessage)) {
            return false;
        }
        DF1CommandRequestMessage that = (DF1CommandRequestMessage)o;
        return this.getCommand() == that.getCommand() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCommand());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("command", (Object)this.getCommand()).toString();
    }
}

