/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestMessage;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationPacketIO;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class CIPEncapsulationReadRequest
extends CIPEncapsulationPacket
implements Message {
    private final DF1RequestMessage request;

    @Override
    @JsonIgnore
    public Integer getCommandType() {
        return 263;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public CIPEncapsulationReadRequest(@JsonProperty(value="sessionHandle") long sessionHandle, @JsonProperty(value="status") long status, @JsonProperty(value="senderContext") short[] senderContext, @JsonProperty(value="options") long options, @JsonProperty(value="request") DF1RequestMessage request) {
        super(sessionHandle, status, senderContext, options);
        this.request = request;
    }

    public DF1RequestMessage getRequest() {
        return this.request;
    }

    @Override
    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @Override
    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        return lengthInBits += this.request.getLengthInBits();
    }

    @Override
    public PlcValue toPlcValue() {
        TreeMap<String, PlcValue> fieldValues = new TreeMap<String, PlcValue>();
        fieldValues.put("request", this.request.toPlcValue());
        return new PlcStruct(fieldValues);
    }

    @Override
    @JsonIgnore
    public MessageIO<CIPEncapsulationPacket, CIPEncapsulationPacket> getMessageIO() {
        return new CIPEncapsulationPacketIO();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CIPEncapsulationReadRequest)) {
            return false;
        }
        CIPEncapsulationReadRequest that = (CIPEncapsulationReadRequest)o;
        return this.getRequest() == that.getRequest() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequest());
    }

    @Override
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).appendSuper(super.toString(style)).append("request", (Object)this.getRequest()).toString();
    }
}

