/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.readwrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationPacketIO;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcStruct;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public abstract class CIPEncapsulationPacket
implements Message {
    private final long sessionHandle;
    private final long status;
    private final short[] senderContext;
    private final long options;

    public abstract Integer getCommandType();

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public CIPEncapsulationPacket(@JsonProperty(value="sessionHandle") long sessionHandle, @JsonProperty(value="status") long status, @JsonProperty(value="senderContext") short[] senderContext, @JsonProperty(value="options") long options) {
        this.sessionHandle = sessionHandle;
        this.status = status;
        this.senderContext = senderContext;
        this.options = options;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public long getStatus() {
        return this.status;
    }

    public short[] getSenderContext() {
        return this.senderContext;
    }

    public long getOptions() {
        return this.options;
    }

    @JsonIgnore
    public int getLengthInBytes() {
        return this.getLengthInBits() / 8;
    }

    @JsonIgnore
    public int getLengthInBits() {
        int lengthInBits = 0;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 8 * this.senderContext.length;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public PlcValue toPlcValue() {
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("sessionHandle", PlcValues.of((long)this.sessionHandle));
        fieldValues.put("status", PlcValues.of((long)this.status));
        ArrayList<PlcValue> plcValues = new ArrayList<PlcValue>(this.senderContext.length);
        for (short item : this.senderContext) {
            plcValues.add(PlcValues.of((short)item));
        }
        fieldValues.put("senderContext", new PlcList(plcValues));
        fieldValues.put("options", PlcValues.of((long)this.options));
        return new PlcStruct(fieldValues);
    }

    @JsonIgnore
    public MessageIO<CIPEncapsulationPacket, CIPEncapsulationPacket> getMessageIO() {
        return new CIPEncapsulationPacketIO();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CIPEncapsulationPacket)) {
            return false;
        }
        CIPEncapsulationPacket that = (CIPEncapsulationPacket)o;
        return this.getSessionHandle() == that.getSessionHandle() && this.getStatus() == that.getStatus() && this.getSenderContext() == that.getSenderContext() && this.getOptions() == that.getOptions();
    }

    public int hashCode() {
        return Objects.hash(this.getSessionHandle(), this.getStatus(), this.getSenderContext(), this.getOptions());
    }

    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toString(ToStringStyle style) {
        return new ToStringBuilder((Object)this, style).append("sessionHandle", this.getSessionHandle()).append("status", this.getStatus()).append("senderContext", this.getSenderContext()).append("options", this.getOptions()).toString();
    }
}

