/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.abeth.field.AbEthField;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandRequestMessage;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandResponseMessageProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestProtectedTypedLogicalRead;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcInteger;
import org.apache.plc4x.java.api.value.PlcList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValues;
import org.apache.plc4x.java.spi.PlcMessageToMessageCodec;
import org.apache.plc4x.java.spi.events.ConnectEvent;
import org.apache.plc4x.java.spi.events.ConnectedEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.spi.messages.InternalPlcRequest;
import org.apache.plc4x.java.spi.messages.PlcRequestContainer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Plc4xAbEthProtocol
extends PlcMessageToMessageCodec<CIPEncapsulationPacket, PlcRequestContainer> {
    private static final Logger logger = LoggerFactory.getLogger(Plc4xAbEthProtocol.class);
    private static final AtomicInteger transactionCounterGenerator = new AtomicInteger(10);
    private static final short[] emptySenderContext = new short[]{0, 0, 0, 0, 0, 0, 0, 0};
    private long sessionHandle;
    private Map<Integer, PlcRequestContainer> requests;
    private int station;

    public Plc4xAbEthProtocol(int station) {
        logger.trace("Created new instance of PLC4X-AB-ETH Protocol");
        this.requests = new HashMap<Integer, PlcRequestContainer>();
        this.station = station;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.trace("Registered user event {}", evt);
        if (evt instanceof ConnectEvent) {
            logger.debug("AB-ETH Sending Connection Request");
            CIPEncapsulationConnectionRequest connectionRequest = new CIPEncapsulationConnectionRequest(0L, 0L, emptySenderContext, 0L);
            ctx.channel().writeAndFlush((Object)connectionRequest);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void encode(ChannelHandlerContext ctx, PlcRequestContainer msg, List<Object> out) throws Exception {
        logger.trace("Encoding {}", (Object)msg);
        InternalPlcRequest request = msg.getRequest();
        if (transactionCounterGenerator.get() > 65000) {
            transactionCounterGenerator.set(10);
        }
        if (request instanceof PlcReadRequest) {
            PlcReadRequest readRequest = (PlcReadRequest)msg.getRequest();
            for (String fieldName : readRequest.getFieldNames()) {
                PlcField field = readRequest.getField(fieldName);
                if (!(field instanceof AbEthField)) {
                    throw new PlcProtocolException("The field should have been of type AbEthField");
                }
                AbEthField abEthField = (AbEthField)field;
                DF1RequestProtectedTypedLogicalRead logicalRead = new DF1RequestProtectedTypedLogicalRead(abEthField.getByteSize(), abEthField.getFileNumber(), abEthField.getFileType().getTypeCode(), abEthField.getElementNumber(), 0);
                DF1CommandRequestMessage requestMessage = new DF1CommandRequestMessage((short)this.station, 5, 0, transactionCounterGenerator.incrementAndGet(), logicalRead);
                CIPEncapsulationReadRequest read = new CIPEncapsulationReadRequest(this.sessionHandle, 0L, emptySenderContext, 0L, requestMessage);
                this.requests.put(requestMessage.getTransactionCounter(), msg);
                out.add(read);
            }
        } else {
            ctx.fireExceptionCaught((Throwable)new PlcProtocolException("Unsupported request type " + request.getClass().getName()));
        }
    }

    protected void decode(ChannelHandlerContext ctx, CIPEncapsulationPacket packet, List<Object> out) throws Exception {
        logger.trace("Received {}, decoding...", (Object)packet);
        if (packet instanceof CIPEncapsulationConnectionResponse) {
            CIPEncapsulationConnectionResponse connectionResponse = (CIPEncapsulationConnectionResponse)packet;
            this.sessionHandle = connectionResponse.getSessionHandle();
            ctx.channel().pipeline().fireUserEventTriggered((Object)new ConnectedEvent());
        } else {
            if (!(packet instanceof CIPEncapsulationReadResponse)) {
                return;
            }
            CIPEncapsulationReadResponse cipResponse = (CIPEncapsulationReadResponse)packet;
            int transactionCounter = cipResponse.getResponse().getTransactionCounter();
            if (!this.requests.containsKey(transactionCounter)) {
                ctx.fireExceptionCaught((Throwable)new PlcProtocolException("Couldn't find request for response with transaction counter " + transactionCounter));
                return;
            }
            PlcRequestContainer requestContainer = this.requests.remove(transactionCounter);
            InternalPlcRequest request = requestContainer.getRequest();
            PlcResponse response = null;
            if (request instanceof PlcReadRequest) {
                response = this.decodeReadResponse(cipResponse, requestContainer);
            } else {
                ctx.fireExceptionCaught((Throwable)new PlcProtocolException("Unsupported request type " + request.getClass().getName()));
            }
            if (response != null) {
                requestContainer.getResponseFuture().complete(response);
            }
        }
    }

    private PlcResponse decodeReadResponse(CIPEncapsulationReadResponse plcReadResponse, PlcRequestContainer requestContainer) {
        InternalPlcReadRequest plcReadRequest = (InternalPlcReadRequest)requestContainer.getRequest();
        HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
        for (String fieldName : plcReadRequest.getFieldNames()) {
            AbEthField field = (AbEthField)plcReadRequest.getField(fieldName);
            PlcResponseCode responseCode = this.decodeResponseCode(plcReadResponse.getResponse().getStatus());
            PlcInteger plcValue = null;
            if (responseCode == PlcResponseCode.OK) {
                try {
                    switch (field.getFileType()) {
                        case INTEGER: {
                            short[] data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (data.length == 1) {
                                    plcValue = new PlcInteger((int)data[0]);
                                    break;
                                }
                                plcValue = new PlcList(Arrays.asList(new short[][]{data}));
                            }
                            break;
                        }
                        case WORD: {
                            short[] data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data[1] >> 7 & 1) == 0) {
                                    plcValue = PlcValues.of((int)((data[1] << 8) + data[0]));
                                    break;
                                }
                                plcValue = PlcValues.of((int)((((~data[1] & 0x7F) << 8) + (~(data[0] - 1) & 0xFF)) * -1));
                            }
                            break;
                        }
                        case DWORD: {
                            short[] data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if ((data[3] >> 7 & 1) == 0) {
                                    plcValue = PlcValues.of((int)((data[3] << 24) + (data[2] << 16) + (data[1] << 8) + data[0]));
                                    break;
                                }
                                plcValue = PlcValues.of((int)((((~data[3] & 0x7F) << 24) + ((~(data[2] - 1) & 0xFF) << 16) + ((~(data[1] - 1) & 0xFF) << 8) + (~(data[0] - 1) & 0xFF)) * -1));
                            }
                            break;
                        }
                        case SINGLEBIT: {
                            short[] data;
                            DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR;
                            if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                                df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                                data = df1PTLR.getData();
                                if (field.getBitNumber() < 8) {
                                    plcValue = PlcValues.of(((data[0] & 1 << field.getBitNumber()) != 0 ? 1 : 0) != 0);
                                    break;
                                }
                                plcValue = PlcValues.of(((data[1] & 1 << field.getBitNumber() - 8) != 0 ? 1 : 0) != 0);
                            }
                            break;
                        }
                        default: {
                            logger.warn("Problem during decoding of field {}: Decoding of file type not implemented; FieldInformation: {}", (Object)fieldName, (Object)field);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Some other error occurred casting field {}, FieldInformation: {}", new Object[]{fieldName, field, e});
                }
            }
            ResponseItem result = new ResponseItem(responseCode, plcValue);
            values.put(fieldName, result);
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    private PlcResponseCode decodeResponseCode(short status) {
        if (status == 0) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.NOT_FOUND;
    }

    private PlcValue decodeReadResponseUnsignedBytePlcValue(AbEthField field, ByteBuf data) {
        Object shorts = null;
        return new PlcInteger(1);
    }
}

