/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.abeth.types.FileType;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;

public class AbEthField
implements PlcField {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^N(?<fileNumber>\\d{1,7}):(?<elementNumber>\\d{1,7})(/(?<bitNumber>\\d{1,7}))?:(?<dataType>[a-zA-Z_]+)(\\[(?<size>\\d+)])?");
    private static final String FILE_NUMBER = "fileNumber";
    private static final String ELEMENT_NUMBER = "elementNumber";
    private static final String BIT_NUMBER = "bitNumber";
    private static final String DATA_TYPE = "dataType";
    private static final String SIZE = "size";
    private final short byteSize;
    private final short fileNumber;
    private final FileType fileType;
    private final short elementNumber;
    private final short bitNumber;

    public AbEthField(short byteSize, short fileNumber, FileType fileType, short elementNumber, short bitNumber) {
        this.byteSize = byteSize;
        this.fileNumber = fileNumber;
        this.fileType = fileType;
        this.elementNumber = elementNumber;
        this.bitNumber = bitNumber;
    }

    public short getByteSize() {
        return this.byteSize;
    }

    public short getFileNumber() {
        return this.fileNumber;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public short getElementNumber() {
        return this.elementNumber;
    }

    public short getBitNumber() {
        return this.bitNumber;
    }

    public static boolean matches(String fieldString) {
        return ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public static AbEthField of(String fieldString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            short byteSize;
            short fileNumber = Short.parseShort(matcher.group(FILE_NUMBER));
            short elementNumber = Short.parseShort(matcher.group(ELEMENT_NUMBER));
            short bitNumber = matcher.group(BIT_NUMBER) != null ? Short.parseShort(matcher.group(BIT_NUMBER)) : (short)0;
            FileType fileType = FileType.valueOf(matcher.group(DATA_TYPE).toUpperCase());
            switch (fileType) {
                case WORD: 
                case SINGLEBIT: {
                    byteSize = 2;
                    break;
                }
                case DWORD: {
                    byteSize = 4;
                    break;
                }
                default: {
                    byteSize = Short.parseShort(matcher.group(SIZE));
                }
            }
            return new AbEthField(byteSize, fileNumber, fileType, elementNumber, bitNumber);
        }
        throw new PlcInvalidFieldException("Unable to parse field address: " + fieldString);
    }
}

