/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.abeth.configuration.AbEthConfiguration;
import org.apache.plc4x.java.abeth.field.AbEthField;
import org.apache.plc4x.java.abeth.field.AbEthFieldHandler;
import org.apache.plc4x.java.abeth.protocol.AbEthProtocolLogic;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.io.CIPEncapsulationPacketIO;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class AbEthDriver
extends GeneratedDriverBase<CIPEncapsulationPacket> {
    public static final int AB_ETH_PORT = 2222;

    public String getProtocolCode() {
        return "ab-eth";
    }

    public String getProtocolName() {
        return "Allen Bradley ETH";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return AbEthConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "raw";
    }

    protected AbEthFieldHandler getFieldHandler() {
        return new AbEthFieldHandler();
    }

    protected ProtocolStackConfigurer<CIPEncapsulationPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(CIPEncapsulationPacket.class, CIPEncapsulationPacketIO.class).withProtocol(AbEthProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public PlcField prepareField(String query) {
        return AbEthField.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2) + 28;
            }
            return -1;
        }
    }
}

