/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.utils.connectionpool.PoolKey;

public class PoolKeyFactory {
    public PoolKey getPoolKey(String url, PlcAuthentication plcAuthentication) throws PlcConnectionException {
        String protocol;
        URI connectionUri;
        Objects.requireNonNull(url);
        try {
            connectionUri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new PlcConnectionException("Invalid plc4j connection string '" + url + "'", (Throwable)e);
        }
        switch (protocol = connectionUri.getScheme().toLowerCase()) {
            case "s7": {
                return new PoolKey(url, plcAuthentication){
                    private final Pattern s7URIPattern;
                    {
                        this.s7URIPattern = Pattern.compile("^(?<poolablePart>s7://((?<ip>[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})|(?<hostname>[a-zA-Z0-9\\.\\-]+))(:(?<port>[0-9]{1,5}))?)(?<params>\\?.*)?");
                    }

                    @Override
                    public String getPoolableKey() {
                        Matcher matcher = this.s7URIPattern.matcher(this.url);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException(this.url + " doesn't match " + this.s7URIPattern);
                        }
                        return Objects.requireNonNull(matcher.group("poolablePart"));
                    }
                };
            }
            case "ads": {
                return new PoolKey(url, plcAuthentication){
                    private final Pattern amsPortPattern;
                    private final Pattern amsNetIdPattern;
                    private final Pattern adsAddressPattern;
                    private final Pattern inetAddressPattern;
                    private final Pattern serialPattern;
                    private final Pattern adsUriPattern;
                    {
                        this.amsPortPattern = Pattern.compile("\\d+");
                        this.amsNetIdPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
                        this.adsAddressPattern = Pattern.compile("(?<targetAmsNetId>" + this.amsNetIdPattern + "):(?<targetAmsPort>" + this.amsPortPattern + ")(/(?<sourceAmsNetId>" + this.amsNetIdPattern + "):(?<sourceAmsPort>" + this.amsPortPattern + "))?");
                        this.inetAddressPattern = Pattern.compile("tcp://(?<host>[\\w.]+)(:(?<port>\\d*))?");
                        this.serialPattern = Pattern.compile("serial://(?<serialDefinition>((?!/\\d).)*)");
                        this.adsUriPattern = Pattern.compile("^(?<poolablePart>ads:(" + this.inetAddressPattern + "|" + this.serialPattern + "))/" + this.adsAddressPattern + "(\\?.*)?");
                    }

                    @Override
                    public String getPoolableKey() {
                        Matcher matcher = this.adsUriPattern.matcher(this.url);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException(this.url + " doesn't match " + this.adsUriPattern);
                        }
                        return Objects.requireNonNull(matcher.group("poolablePart"));
                    }
                };
            }
            case "modbus": {
                return new PoolKey(url, plcAuthentication){
                    private final Pattern inetAddressPattern;
                    private final Pattern serialPattern;
                    private final Pattern modbusUriPattern;
                    {
                        this.inetAddressPattern = Pattern.compile("tcp://(?<host>[\\w.]+)(:(?<port>\\d*))?");
                        this.serialPattern = Pattern.compile("serial://(?<serialDefinition>((?!/\\d).)*)");
                        this.modbusUriPattern = Pattern.compile("^(?<poolablePart>modbus:(" + this.inetAddressPattern + "|" + this.serialPattern + "))/?(?<params>\\?.*)?");
                    }

                    @Override
                    public String getPoolableKey() {
                        Matcher matcher = this.modbusUriPattern.matcher(this.url);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException(this.url + " doesn't match " + this.modbusUriPattern);
                        }
                        return Objects.requireNonNull(matcher.group("poolablePart"));
                    }
                };
            }
        }
        return new PoolKey(url, plcAuthentication){

            @Override
            public String getPoolableKey() {
                return this.url;
            }
        };
    }
}

