/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValueAdapter;
import org.apache.plc4x.java.api.value.PlcValues;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcList
extends PlcValueAdapter {
    private final List<PlcValue> listItems;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcList(@JsonProperty(value="listItems") List<?> listItems) {
        List safelist = listItems.stream().map(plcValue -> {
            if (plcValue instanceof PlcValue) {
                return (PlcValue)plcValue;
            }
            return PlcValues.of(plcValue);
        }).collect(Collectors.toList());
        this.listItems = Collections.unmodifiableList(safelist);
    }

    @Override
    public Object getObject() {
        return this.listItems;
    }

    @Override
    @JsonIgnore
    public boolean isList() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return this.listItems.size();
    }

    @Override
    @JsonIgnore
    public PlcValue getIndex(int i) {
        return this.listItems.get(i);
    }

    @Override
    @JsonIgnore
    public List<? extends PlcValue> getList() {
        return this.listItems;
    }

    @JsonIgnore
    public String toString() {
        return "[" + this.listItems.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }
}

