/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcInteger
extends PlcSimpleValue<Integer> {
    public PlcInteger(Integer value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcInteger(@JsonProperty(value="value") int value) {
        super(value, false);
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Integer)this.value).equals(0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Integer)this.value <= 127 && (Integer)this.value >= -128;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Integer)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && (Integer)this.value <= Short.MAX_VALUE && (Integer)this.value >= Short.MIN_VALUE;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Integer)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return (Integer)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Integer)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Integer)this.value).intValue());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Integer)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Integer)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((Integer)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Integer.toString((Integer)this.value);
    }
}

