/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcFloat
extends PlcSimpleValue<Float> {
    public PlcFloat(Float value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcFloat(@JsonProperty(value="value") float value) {
        super(Float.valueOf(value), false);
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Float)this.value).equals(Float.valueOf(0.0f));
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && ((Float)this.value).floatValue() <= 127.0f && ((Float)this.value).floatValue() >= -128.0f;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Float)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && ((Float)this.value).floatValue() <= 32767.0f && ((Float)this.value).floatValue() >= -32768.0f;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Float)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && ((Float)this.value).floatValue() <= 2.1474836E9f && ((Float)this.value).floatValue() >= -2.1474836E9f;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Float)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && ((Float)this.value).floatValue() <= 9.223372E18f && ((Float)this.value).floatValue() >= -9.223372E18f;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Float)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Float)this.value).longValue());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Float)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Float)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal(((Float)this.value).floatValue());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Float.toString(((Float)this.value).floatValue());
    }
}

