/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcDouble
extends PlcSimpleValue<Double> {
    public PlcDouble(Double value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDouble(@JsonProperty(value="value") double value) {
        super(value, false);
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Double)this.value).equals(0.0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Double)this.value <= 127.0 && (Double)this.value >= -128.0;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Double)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && (Double)this.value <= 32767.0 && (Double)this.value >= -32768.0;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Double)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && (Double)this.value <= 2.147483647E9 && (Double)this.value >= -2.147483648E9;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Double)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && (Double)this.value <= 9.223372036854776E18 && (Double)this.value >= -9.223372036854776E18;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Double)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Double)this.value).longValue());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return this.value != null && (Double)this.value <= 3.4028234663852886E38 && (Double)this.value >= -3.4028234663852886E38;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Double)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return (Double)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((Double)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Double.toString((Double)this.value);
    }
}

