/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcBigDecimal
extends PlcSimpleValue<BigDecimal> {
    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcBigDecimal(@JsonProperty(value="value") BigDecimal value) {
        super(value, true);
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((BigDecimal)this.value).equals(BigDecimal.ZERO);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(127L)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(-128L)) >= 0;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((BigDecimal)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(32767L)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(-32768L)) >= 0;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((BigDecimal)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((BigDecimal)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((BigDecimal)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return ((BigDecimal)this.value).toBigInteger();
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((BigDecimal)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((BigDecimal)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return (BigDecimal)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return ((BigDecimal)this.value).toString();
    }
}

