/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.exceptions;

import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;

public class PlcInvalidFieldException
extends PlcRuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String DOES_NOT_MATCH = " doesn't match ";
    private final String fieldToBeParsed;

    public PlcInvalidFieldException(String fieldToBeParsed) {
        super(fieldToBeParsed + " invalid");
        this.fieldToBeParsed = fieldToBeParsed;
    }

    public PlcInvalidFieldException(String fieldToBeParsed, Throwable cause) {
        super(fieldToBeParsed + " invalid", cause);
        this.fieldToBeParsed = fieldToBeParsed;
    }

    public PlcInvalidFieldException(String fieldToBeParsed, Pattern pattern) {
        super(fieldToBeParsed + DOES_NOT_MATCH + pattern);
        this.fieldToBeParsed = fieldToBeParsed;
    }

    public PlcInvalidFieldException(String fieldToBeParsed, Pattern pattern, Throwable cause) {
        super(fieldToBeParsed + DOES_NOT_MATCH + pattern, cause);
        this.fieldToBeParsed = fieldToBeParsed;
    }

    public PlcInvalidFieldException(String fieldToBeParsed, Pattern pattern, String readablePattern) {
        super(fieldToBeParsed + DOES_NOT_MATCH + readablePattern + '(' + pattern + ')');
        this.fieldToBeParsed = fieldToBeParsed;
    }

    public String getFieldToBeParsed() {
        return this.fieldToBeParsed;
    }
}

