/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.text.BlockListener;
import org.apache.pivot.wtk.text.Element;

public abstract class Block
extends Element {
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private BlockListenerList blockListeners = new BlockListenerList();

    public Block() {
    }

    public Block(Block blockElement, boolean recursive) {
        super(blockElement, recursive);
        this.horizontalAlignment = blockElement.horizontalAlignment;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        HorizontalAlignment previousHorizontalAlignment = this.horizontalAlignment;
        if (previousHorizontalAlignment != horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            this.blockListeners.horizontalAlignmentChanged(this, previousHorizontalAlignment);
        }
    }

    public ListenerList<BlockListener> getBlockListeners() {
        return this.blockListeners;
    }

    private static class BlockListenerList
    extends ListenerList<BlockListener>
    implements BlockListener {
        private BlockListenerList() {
        }

        @Override
        public void horizontalAlignmentChanged(Block block, HorizontalAlignment previousHorizontalAlignment) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                BlockListener listener = (BlockListener)i$.next();
                listener.horizontalAlignmentChanged(block, previousHorizontalAlignment);
            }
        }
    }
}

