/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.TextPaneListener;
import org.apache.pivot.wtk.TextPaneSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinBulletedListView;
import org.apache.pivot.wtk.skin.TextPaneSkinComponentNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinDocumentView;
import org.apache.pivot.wtk.skin.TextPaneSkinImageNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinListItemView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.skin.TextPaneSkinNumberedListView;
import org.apache.pivot.wtk.skin.TextPaneSkinParagraphView;
import org.apache.pivot.wtk.skin.TextPaneSkinSpanView;
import org.apache.pivot.wtk.skin.TextPaneSkinTextNodeView;
import org.apache.pivot.wtk.text.BulletedList;
import org.apache.pivot.wtk.text.ComponentNode;
import org.apache.pivot.wtk.text.Document;
import org.apache.pivot.wtk.text.ImageNode;
import org.apache.pivot.wtk.text.List;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NumberedList;
import org.apache.pivot.wtk.text.Paragraph;
import org.apache.pivot.wtk.text.TextNode;
import org.apache.pivot.wtk.text.TextSpan;

public class TextPaneSkin
extends ContainerSkin
implements TextPane.Skin,
TextPaneListener,
TextPaneSelectionListener {
    private TextPaneSkinDocumentView documentView = null;
    private int caretX = 0;
    private Rectangle caret = new Rectangle();
    private Area selection = null;
    private boolean caretOn = false;
    private int anchor = -1;
    private TextPane.ScrollDirection scrollDirection = null;
    private int mouseX = -1;
    private BlinkCaretCallback blinkCaretCallback = new BlinkCaretCallback();
    private ApplicationContext.ScheduledCallback scheduledBlinkCaretCallback = null;
    private ScrollSelectionCallback scrollSelectionCallback = new ScrollSelectionCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollSelectionCallback = null;
    private Font font;
    private Color color;
    private Color inactiveColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Insets margin = new Insets(4);
    private boolean wrapText = true;
    private static final int SCROLL_RATE = 30;

    public TextPaneSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont();
        this.color = Color.BLACK;
        this.inactiveColor = Color.GRAY;
        this.selectionColor = Color.LIGHT_GRAY;
        this.selectionBackgroundColor = Color.BLACK;
        this.inactiveSelectionColor = Color.LIGHT_GRAY;
        this.inactiveSelectionBackgroundColor = Color.BLACK;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        TextPane textPane = (TextPane)component;
        textPane.getTextPaneListeners().add((Object)this);
        textPane.getTextPaneSelectionListeners().add((Object)this);
        textPane.setCursor(Cursor.TEXT);
        Document document = textPane.getDocument();
        if (document != null) {
            this.documentView = (TextPaneSkinDocumentView)this.createNodeView(document);
            this.documentView.attach();
            this.updateSelection();
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth;
        if (this.documentView == null) {
            preferredWidth = 0;
        } else {
            Dimensions documentDimensions = this.documentView.getPreferredSize(Integer.MAX_VALUE);
            preferredWidth = documentDimensions.width + this.margin.left + this.margin.right;
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight;
        if (this.documentView == null || width == -1) {
            preferredHeight = 0;
        } else {
            int breakWidth = this.wrapText ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
            Dimensions documentDimensions = this.documentView.getPreferredSize(breakWidth);
            preferredHeight = documentDimensions.height + this.margin.top + this.margin.bottom;
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredHeight;
        int preferredWidth;
        if (this.documentView == null) {
            preferredWidth = 0;
            preferredHeight = 0;
        } else {
            Dimensions documentDimensions = this.documentView.getPreferredSize(Integer.MAX_VALUE);
            preferredWidth = documentDimensions.width + this.margin.left + this.margin.right;
            preferredHeight = documentDimensions.height + this.margin.top + this.margin.bottom;
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    @Override
    public int getBaseline(int width, int height) {
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        return this.margin.top + Math.round(ascent);
    }

    @Override
    public void layout() {
        if (this.documentView != null) {
            TextPane textPane = (TextPane)this.getComponent();
            int width = this.getWidth();
            int breakWidth = this.wrapText ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
            this.documentView.layout(breakWidth);
            this.documentView.setSkinLocation(this.margin.left, this.margin.top);
            this.updateSelection();
            this.caretX = this.caret.x;
            if (textPane.isFocused()) {
                this.scrollCharacterToVisible(textPane.getSelectionStart());
            }
            this.showCaret(textPane.isFocused() && textPane.getSelectionLength() == 0);
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        TextPane textPane = (TextPane)this.getComponent();
        if (this.documentView != null) {
            if (this.selection != null) {
                graphics.setColor(textPane.isFocused() && textPane.isEditable() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor);
                graphics.fill(this.selection);
            }
            int width = this.getWidth();
            int breakWidth = this.wrapText ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
            this.documentView.layout(breakWidth);
            graphics.translate(this.margin.left, this.margin.top);
            this.documentView.paint(graphics);
            graphics.translate(-this.margin.left, -this.margin.top);
            if (this.selection == null && this.caretOn && textPane.isFocused()) {
                graphics.setColor(textPane.isEditable() ? this.color : this.inactiveColor);
                graphics.fill(this.caret);
            }
        }
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        int offset;
        if (this.documentView == null) {
            offset = -1;
        } else {
            int xUpdated = Math.min(this.documentView.getWidth() - 1, Math.max(x - this.margin.left, 0));
            offset = y < this.margin.top ? this.documentView.getNextInsertionPoint(xUpdated, -1, TextPane.ScrollDirection.DOWN) : (y > this.documentView.getHeight() + this.margin.top ? this.documentView.getNextInsertionPoint(xUpdated, -1, TextPane.ScrollDirection.UP) : this.documentView.getInsertionPoint(xUpdated, y - this.margin.top));
        }
        return offset;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = this.documentView == null ? -1 : this.documentView.getNextInsertionPoint(x - this.margin.left, from, direction);
        return offset;
    }

    @Override
    public int getRowAt(int offset) {
        int rowIndex = this.documentView == null ? -1 : this.documentView.getRowAt(offset);
        return rowIndex;
    }

    @Override
    public int getRowCount() {
        int rowCount = this.documentView == null ? 0 : this.documentView.getRowCount();
        return rowCount;
    }

    @Override
    public Bounds getCharacterBounds(int offset) {
        Bounds characterBounds;
        if (this.documentView == null) {
            characterBounds = null;
        } else {
            characterBounds = this.documentView.getCharacterBounds(offset);
            if (characterBounds != null) {
                characterBounds = characterBounds.translate(this.margin.left, this.margin.top);
            }
        }
        return characterBounds;
    }

    private void scrollCharacterToVisible(int offset) {
        TextPane textPane = (TextPane)this.getComponent();
        Bounds characterBounds = this.getCharacterBounds(offset);
        if (characterBounds != null) {
            textPane.scrollAreaToVisible(characterBounds.x, characterBounds.y, characterBounds.width, characterBounds.height);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TextPaneSkin.decodeFont(font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public void setInactiveColor(Color inactiveColor) {
        if (inactiveColor == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.inactiveColor = inactiveColor;
        this.repaintComponent();
    }

    public final void setInactiveColor(String inactiveColor) {
        if (inactiveColor == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(inactiveColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor(selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor(selectionBackgroundColor));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor(inactiveSelectionColor));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor(inactiveSelectionBackgroundColor));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.margin = margin;
        this.invalidateComponent();
    }

    public final void setMargin(Dictionary<String, ?> margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(new Insets(margin));
    }

    public final void setMargin(int margin) {
        this.setMargin(new Insets(margin));
    }

    public final void setMargin(Number margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(margin.intValue());
    }

    public final void setMargin(String margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(Insets.decode(margin));
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        if (this.wrapText != wrapText) {
            this.wrapText = wrapText;
            if (this.documentView != null) {
                this.documentView.invalidateUpTree();
            }
        }
    }

    @Override
    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            TextPane textPane = (TextPane)this.getComponent();
            Bounds visibleArea = textPane.getVisibleArea();
            visibleArea = new Bounds(visibleArea.x, visibleArea.y, visibleArea.width, visibleArea.height);
            if (y >= visibleArea.y && y < visibleArea.y + visibleArea.height) {
                if (this.scheduledScrollSelectionCallback != null) {
                    this.scheduledScrollSelectionCallback.cancel();
                    this.scheduledScrollSelectionCallback = null;
                }
                this.scrollDirection = null;
                int offset = this.getInsertionPoint(x, y);
                if (offset != -1) {
                    if (offset > this.anchor) {
                        textPane.setSelection(this.anchor, offset - this.anchor);
                    } else {
                        textPane.setSelection(offset, this.anchor - offset);
                    }
                }
            } else if (this.scheduledScrollSelectionCallback == null) {
                this.scrollDirection = y < visibleArea.y ? TextPane.ScrollDirection.UP : TextPane.ScrollDirection.DOWN;
                this.scheduledScrollSelectionCallback = ApplicationContext.scheduleRecurringCallback(this.scrollSelectionCallback, 30L);
                this.scrollSelectionCallback.run();
            }
            this.mouseX = x;
        } else if (Mouse.isPressed(Mouse.Button.LEFT) && Mouse.getCapturer() == null && this.anchor != -1) {
            Mouse.capture(component);
        }
        return consumed;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        if (button == Mouse.Button.LEFT) {
            TextPane textPane = (TextPane)component;
            this.anchor = this.getInsertionPoint(x, y);
            if (this.anchor != -1) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int selectionStart = textPane.getSelectionStart();
                    if (this.anchor > selectionStart) {
                        textPane.setSelection(selectionStart, this.anchor - selectionStart);
                    } else {
                        textPane.setSelection(this.anchor, selectionStart - this.anchor);
                    }
                } else {
                    textPane.setSelection(this.anchor, 0);
                    consumed = true;
                }
            }
            this.caretX = this.caret.x;
            textPane.requestFocus();
        }
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            if (this.scheduledScrollSelectionCallback != null) {
                this.scheduledScrollSelectionCallback.cancel();
                this.scheduledScrollSelectionCallback = null;
            }
            Mouse.release();
        }
        this.anchor = -1;
        this.scrollDirection = null;
        this.mouseX = -1;
        return consumed;
    }

    @Override
    public boolean keyTyped(Component component, char character) {
        Document document;
        boolean consumed = super.keyTyped(component, character);
        TextPane textPane = (TextPane)this.getComponent();
        if (textPane.isEditable() && (document = textPane.getDocument()) != null && character > '\u001f' && character != '\u007f' && !Keyboard.isPressed(Keyboard.Modifier.META)) {
            textPane.insert(character);
            this.showCaret(true);
        }
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        TextPane textPane = (TextPane)this.getComponent();
        Document document = textPane.getDocument();
        Keyboard.Modifier commandModifier = Platform.getCommandModifier();
        if (document != null) {
            if (keyCode == 10 && textPane.isEditable()) {
                textPane.insertParagraph();
                consumed = true;
            } else if (keyCode == 127 && textPane.isEditable()) {
                textPane.delete(false);
                consumed = true;
            } else if (keyCode == 8 && textPane.isEditable()) {
                textPane.delete(true);
                consumed = true;
            } else if (keyCode == 37) {
                int selectionStart;
                int selectionLength = textPane.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    if (selectionStart > 0) {
                        --selectionStart;
                        ++selectionLength;
                    }
                } else if (Keyboard.isPressed(Keyboard.Modifier.CTRL)) {
                    if (selectionStart > 0) {
                        for (selectionStart = textPane.getSelectionStart(); selectionStart > 0 && Character.isWhitespace(document.getCharacterAt(selectionStart - 1)); --selectionStart) {
                        }
                        while (selectionStart > 0 && !Character.isWhitespace(document.getCharacterAt(selectionStart - 1))) {
                            --selectionStart;
                        }
                        selectionLength = 0;
                    }
                } else {
                    if (selectionLength == 0 && selectionStart > 0) {
                        --selectionStart;
                    }
                    selectionLength = 0;
                }
                textPane.setSelection(selectionStart, selectionLength);
                this.scrollCharacterToVisible(selectionStart);
                this.caretX = this.caret.x;
                consumed = true;
            } else if (keyCode == 39) {
                int selectionStart;
                int selectionLength = textPane.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    if (selectionStart + selectionLength < document.getCharacterCount()) {
                        ++selectionLength;
                    }
                    textPane.setSelection(selectionStart, selectionLength);
                    this.scrollCharacterToVisible(selectionStart + selectionLength);
                } else if (Keyboard.isPressed(Keyboard.Modifier.CTRL)) {
                    if (selectionStart < document.getCharacterCount()) {
                        for (selectionStart = textPane.getSelectionStart(); selectionStart < document.getCharacterCount() - 1 && !Character.isWhitespace(document.getCharacterAt(selectionStart)); ++selectionStart) {
                        }
                        while (selectionStart < document.getCharacterCount() - 1 && Character.isWhitespace(document.getCharacterAt(selectionStart))) {
                            ++selectionStart;
                        }
                        textPane.setSelection(selectionStart, 0);
                        this.scrollCharacterToVisible(selectionStart);
                        this.caretX = this.caret.x;
                    }
                } else {
                    if (selectionLength > 0) {
                        selectionStart += selectionLength - 1;
                    }
                    if (selectionStart < document.getCharacterCount() - 1) {
                        ++selectionStart;
                    }
                    textPane.setSelection(selectionStart, 0);
                    this.scrollCharacterToVisible(selectionStart);
                    this.caretX = this.caret.x;
                }
                consumed = true;
            } else if (keyCode == 38) {
                int selectionLength;
                int selectionStart = textPane.getSelectionStart();
                int offset = this.getNextInsertionPoint(this.caretX, selectionStart, TextPane.ScrollDirection.UP);
                if (offset == -1) {
                    offset = 0;
                }
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int selectionEnd = selectionStart + textPane.getSelectionLength() - 1;
                    selectionLength = selectionEnd - offset + 1;
                } else {
                    selectionLength = 0;
                }
                textPane.setSelection(offset, selectionLength);
                this.scrollCharacterToVisible(offset);
                consumed = true;
            } else if (keyCode == 40) {
                int selectionStart = textPane.getSelectionStart();
                int selectionLength = textPane.getSelectionLength();
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int x;
                    int from;
                    if (selectionLength == 0) {
                        from = selectionStart;
                        x = this.caretX;
                    } else {
                        from = selectionStart + selectionLength - 1;
                        Bounds trailingSelectionBounds = this.getCharacterBounds(from);
                        x = trailingSelectionBounds.x + trailingSelectionBounds.width;
                    }
                    int offset = this.getNextInsertionPoint(x, from, TextPane.ScrollDirection.DOWN);
                    if (offset == -1) {
                        offset = this.documentView.getCharacterCount() - 1;
                    } else if (document.getCharacterAt(offset) == '\n' && offset < this.documentView.getCharacterCount() - 1) {
                        ++offset;
                    }
                    textPane.setSelection(selectionStart, offset - selectionStart);
                    this.scrollCharacterToVisible(offset);
                } else {
                    int from = selectionLength == 0 ? selectionStart : selectionStart + selectionLength - 1;
                    int offset = this.getNextInsertionPoint(this.caretX, from, TextPane.ScrollDirection.DOWN);
                    if (offset == -1) {
                        offset = this.documentView.getCharacterCount() - 1;
                    }
                    textPane.setSelection(offset, 0);
                    this.scrollCharacterToVisible(offset);
                }
                consumed = true;
            } else if (Keyboard.isPressed(commandModifier) && keyCode == 9 && textPane.isEditable()) {
                textPane.insert("\t");
                this.showCaret(true);
                consumed = true;
            } else if (Keyboard.isPressed(commandModifier)) {
                if (keyCode == 65) {
                    textPane.setSelection(0, document.getCharacterCount());
                    consumed = true;
                } else if (keyCode == 88 && textPane.isEditable()) {
                    textPane.cut();
                    consumed = true;
                } else if (keyCode == 67) {
                    textPane.copy();
                    consumed = true;
                } else if (keyCode == 86 && textPane.isEditable()) {
                    textPane.paste();
                    consumed = true;
                } else if (keyCode == 90 && textPane.isEditable()) {
                    if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                        textPane.redo();
                    } else {
                        textPane.undo();
                    }
                    consumed = true;
                }
            } else if (keyCode == 36) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    textPane.setSelection(0, textPane.getSelectionStart());
                } else {
                    textPane.setSelection(0, 0);
                }
                this.scrollCharacterToVisible(0);
                consumed = true;
            } else if (keyCode == 35) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int selectionStart = textPane.getSelectionStart();
                    textPane.setSelection(selectionStart, textPane.getCharacterCount() - selectionStart);
                } else {
                    textPane.setSelection(textPane.getCharacterCount() - 1, 0);
                }
                this.scrollCharacterToVisible(textPane.getCharacterCount() - 1);
                consumed = true;
            } else if (keyCode == 155) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT) && textPane.isEditable()) {
                    textPane.paste();
                    consumed = true;
                }
            } else {
                consumed = super.keyPressed(component, keyCode, keyLocation);
            }
        }
        return consumed;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        TextPane textPane = (TextPane)this.getComponent();
        if (textPane.isFocused() && textPane.getSelectionLength() == 0) {
            this.scrollCharacterToVisible(textPane.getSelectionStart());
            this.showCaret(true);
        } else {
            this.showCaret(false);
        }
        this.repaintComponent();
    }

    @Override
    public void documentChanged(TextPane textPane, Document previousDocument) {
        Document document;
        if (this.documentView != null) {
            this.documentView.detach();
            this.documentView = null;
        }
        if ((document = textPane.getDocument()) != null) {
            this.documentView = (TextPaneSkinDocumentView)this.createNodeView(document);
            this.documentView.attach();
        }
        this.invalidateComponent();
    }

    @Override
    public void editableChanged(TextPane textPane) {
    }

    @Override
    public void selectionChanged(TextPane textPane, int previousSelectionStart, int previousSelectionLength) {
        if (this.documentView != null && this.documentView.isValid()) {
            Rectangle bounds;
            if (this.selection == null) {
                textPane.repaint(this.caret.x, this.caret.y, this.caret.width, this.caret.height);
            } else {
                bounds = this.selection.getBounds();
                textPane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            this.updateSelection();
            if (this.selection == null) {
                this.showCaret(textPane.isFocused());
            } else {
                this.showCaret(false);
                bounds = this.selection.getBounds();
                textPane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    TextPaneSkinNodeView createNodeView(Node node) {
        TextPaneSkinNodeView nodeView = null;
        if (node instanceof Document) {
            nodeView = new TextPaneSkinDocumentView(this, (Document)node);
        } else if (node instanceof Paragraph) {
            nodeView = new TextPaneSkinParagraphView((Paragraph)node);
        } else if (node instanceof TextNode) {
            nodeView = new TextPaneSkinTextNodeView((TextNode)node);
        } else if (node instanceof ImageNode) {
            nodeView = new TextPaneSkinImageNodeView((ImageNode)node);
        } else if (node instanceof ComponentNode) {
            nodeView = new TextPaneSkinComponentNodeView((ComponentNode)node);
        } else if (node instanceof TextSpan) {
            nodeView = new TextPaneSkinSpanView((TextSpan)node);
        } else if (node instanceof NumberedList) {
            nodeView = new TextPaneSkinNumberedListView((NumberedList)node);
        } else if (node instanceof BulletedList) {
            nodeView = new TextPaneSkinBulletedListView((BulletedList)node);
        } else if (node instanceof List.Item) {
            nodeView = new TextPaneSkinListItemView((List.Item)node);
        } else {
            throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
        }
        return nodeView;
    }

    private void updateSelection() {
        if (this.documentView.getCharacterCount() > 0) {
            TextPane textPane = (TextPane)this.getComponent();
            int selectionStart = textPane.getSelectionStart();
            Bounds leadingSelectionBounds = this.getCharacterBounds(selectionStart);
            if (leadingSelectionBounds == null) {
                throw new IllegalStateException("no bounds for selection " + selectionStart);
            }
            this.caret = leadingSelectionBounds.toRectangle();
            this.caret.width = 1;
            int selectionLength = textPane.getSelectionLength();
            if (selectionLength > 0) {
                int lastRowIndex;
                int selectionEnd = selectionStart + selectionLength - 1;
                Bounds trailingSelectionBounds = this.getCharacterBounds(selectionEnd);
                this.selection = new Area();
                int firstRowIndex = this.getRowAt(selectionStart);
                if (firstRowIndex == (lastRowIndex = this.getRowAt(selectionEnd))) {
                    this.selection.add(new Area(new Rectangle(leadingSelectionBounds.x, leadingSelectionBounds.y, trailingSelectionBounds.x + trailingSelectionBounds.width - leadingSelectionBounds.x, trailingSelectionBounds.y + trailingSelectionBounds.height - leadingSelectionBounds.y)));
                } else {
                    int width = this.getWidth();
                    this.selection.add(new Area(new Rectangle(leadingSelectionBounds.x, leadingSelectionBounds.y, width - this.margin.right - leadingSelectionBounds.x, leadingSelectionBounds.height)));
                    if (lastRowIndex - firstRowIndex > 0) {
                        this.selection.add(new Area(new Rectangle(this.margin.left, leadingSelectionBounds.y + leadingSelectionBounds.height, width - (this.margin.left + this.margin.right), trailingSelectionBounds.y - (leadingSelectionBounds.y + leadingSelectionBounds.height))));
                    }
                    this.selection.add(new Area(new Rectangle(this.margin.left, trailingSelectionBounds.y, trailingSelectionBounds.x + trailingSelectionBounds.width - this.margin.left, trailingSelectionBounds.height)));
                }
            } else {
                this.selection = null;
            }
        } else {
            this.caret = new Rectangle();
            this.selection = null;
        }
    }

    private void showCaret(boolean show) {
        if (this.scheduledBlinkCaretCallback != null) {
            this.scheduledBlinkCaretCallback.cancel();
        }
        if (show) {
            this.caretOn = true;
            this.scheduledBlinkCaretCallback = ApplicationContext.scheduleRecurringCallback(this.blinkCaretCallback, Platform.getCursorBlinkRate());
            this.blinkCaretCallback.run();
        } else {
            this.scheduledBlinkCaretCallback = null;
        }
    }

    Area getSelection() {
        return this.selection;
    }

    void invalidateNodeViewTree() {
        this.documentView.invalidateDownTree();
        this.invalidateComponent();
    }

    private class ScrollSelectionCallback
    implements Runnable {
        private ScrollSelectionCallback() {
        }

        @Override
        public void run() {
            TextPane textPane = (TextPane)TextPaneSkin.this.getComponent();
            int selectionStart = textPane.getSelectionStart();
            int selectionLength = textPane.getSelectionLength();
            int selectionEnd = selectionStart + selectionLength - 1;
            switch (TextPaneSkin.this.scrollDirection) {
                case UP: {
                    int offset = TextPaneSkin.this.getNextInsertionPoint(TextPaneSkin.this.mouseX, selectionStart, TextPaneSkin.this.scrollDirection);
                    if (offset == -1) break;
                    textPane.setSelection(offset, selectionEnd - offset + 1);
                    TextPaneSkin.this.scrollCharacterToVisible(offset + 1);
                    break;
                }
                case DOWN: {
                    int offset = TextPaneSkin.this.getNextInsertionPoint(TextPaneSkin.this.mouseX, selectionEnd, TextPaneSkin.this.scrollDirection);
                    if (offset == -1) break;
                    Document document = textPane.getDocument();
                    if (document.getCharacterAt(offset) == '\n' && offset < TextPaneSkin.this.documentView.getCharacterCount() - 1) {
                        ++offset;
                    }
                    textPane.setSelection(selectionStart, offset - selectionStart);
                    TextPaneSkin.this.scrollCharacterToVisible(offset - 1);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class BlinkCaretCallback
    implements Runnable {
        private BlinkCaretCallback() {
        }

        @Override
        public void run() {
            TextPaneSkin.this.caretOn = !TextPaneSkin.this.caretOn;
            if (TextPaneSkin.this.selection == null) {
                TextPane textPane = (TextPane)TextPaneSkin.this.getComponent();
                textPane.repaint(((TextPaneSkin)TextPaneSkin.this).caret.x, ((TextPaneSkin)TextPaneSkin.this).caret.y, ((TextPaneSkin)TextPaneSkin.this).caret.width, ((TextPaneSkin)TextPaneSkin.this).caret.height);
            }
        }
    }
}

