/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class PushButtonSkin
extends ButtonSkin {
    protected boolean pressed = false;

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.pressed = false;
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.pressed = false;
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        this.pressed = true;
        this.repaintComponent();
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        this.pressed = false;
        this.repaintComponent();
        return consumed;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        PushButton pushButton = (PushButton)this.getComponent();
        pushButton.press();
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = true;
            this.repaintComponent();
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        PushButton pushButton = (PushButton)this.getComponent();
        if (keyCode == 32) {
            this.pressed = false;
            this.repaintComponent();
            pushButton.press();
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }
}

