/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.ImageViewListener;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.media.ImageListener;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class ImageViewSkin
extends ComponentSkin
implements ImageViewListener {
    private Color backgroundColor = null;
    private float opacity = 1.0f;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private boolean fill = false;
    private boolean preserveAspectRatio = true;
    private int imageX = 0;
    private int imageY = 0;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ImageListener imageListener = new ImageListener(){

        @Override
        public void sizeChanged(Image image, int previousWidth, int previousHeight) {
            ImageViewSkin.this.invalidateComponent();
        }

        @Override
        public void baselineChanged(Image image, int previousBaseline) {
            ImageViewSkin.this.invalidateComponent();
        }

        @Override
        public void regionUpdated(Image image, int x, int y, int width, int height) {
            Bounds bounds = new Bounds(ImageViewSkin.this.imageX + (int)Math.floor((float)x * ImageViewSkin.this.scaleX), ImageViewSkin.this.imageY + (int)Math.floor((float)y * ImageViewSkin.this.scaleY), (int)Math.ceil((float)width * ImageViewSkin.this.scaleX) + 1, (int)Math.ceil((float)height * ImageViewSkin.this.scaleY) + 1);
            ImageViewSkin.this.repaintComponent(bounds);
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        ImageView imageView = (ImageView)component;
        imageView.getImageViewListeners().add((Object)this);
        Image image = imageView.getImage();
        if (image != null) {
            image.getImageListeners().add((Object)this.imageListener);
        }
    }

    @Override
    public int getPreferredWidth(int height) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? 0 : image.getWidth();
    }

    @Override
    public int getPreferredHeight(int width) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? 0 : image.getHeight();
    }

    @Override
    public Dimensions getPreferredSize() {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        return image == null ? new Dimensions(0, 0) : new Dimensions(image.getWidth(), image.getHeight());
    }

    @Override
    public int getBaseline(int width, int height) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        int baseline = -1;
        if (image != null && (baseline = image.getBaseline()) != -1) {
            Dimensions imageSize = image.getSize();
            if (this.fill) {
                if (this.preserveAspectRatio) {
                    float aspectRatio = (float)width / (float)height;
                    float imageAspectRatio = (float)imageSize.width / (float)imageSize.height;
                    if (aspectRatio > imageAspectRatio) {
                        baseline = (int)((float)baseline * ((float)height / (float)imageSize.height));
                    } else {
                        float scaleYLocal = (float)width / (float)imageSize.width;
                        baseline = (int)((float)baseline * scaleYLocal);
                        baseline += (int)((float)height - (float)imageSize.height * scaleYLocal) / 2;
                    }
                } else {
                    baseline = (int)((float)baseline * ((float)height / (float)imageSize.height));
                }
            } else if (this.verticalAlignment == VerticalAlignment.CENTER) {
                baseline += (height - imageSize.height) / 2;
            } else if (this.verticalAlignment == VerticalAlignment.BOTTOM) {
                baseline += height - imageSize.height;
            }
        }
        return baseline;
    }

    @Override
    public void layout() {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        if (image != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            Dimensions imageSize = image.getSize();
            if (this.fill) {
                if (this.preserveAspectRatio) {
                    float aspectRatio = (float)width / (float)height;
                    float imageAspectRatio = (float)imageSize.width / (float)imageSize.height;
                    if (aspectRatio > imageAspectRatio) {
                        this.imageY = 0;
                        this.scaleY = (float)height / (float)imageSize.height;
                        this.imageX = (int)((float)width - (float)imageSize.width * this.scaleY) / 2;
                        this.scaleX = this.scaleY;
                    } else {
                        this.imageX = 0;
                        this.scaleX = (float)width / (float)imageSize.width;
                        this.imageY = (int)((float)height - (float)imageSize.height * this.scaleX) / 2;
                        this.scaleY = this.scaleX;
                    }
                } else {
                    this.imageX = 0;
                    this.scaleX = (float)width / (float)imageSize.width;
                    this.imageY = 0;
                    this.scaleY = (float)height / (float)imageSize.height;
                }
            } else {
                this.imageX = this.horizontalAlignment == HorizontalAlignment.CENTER ? (width - imageSize.width) / 2 : (this.horizontalAlignment == HorizontalAlignment.RIGHT ? width - imageSize.width : 0);
                this.scaleX = 1.0f;
                this.imageY = this.verticalAlignment == VerticalAlignment.CENTER ? (height - imageSize.height) / 2 : (this.verticalAlignment == VerticalAlignment.BOTTOM ? height - imageSize.height : 0);
                this.scaleY = 1.0f;
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        ImageView imageView = (ImageView)this.getComponent();
        Image image = imageView.getImage();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        if (image != null) {
            Graphics2D imageGraphics = (Graphics2D)graphics.create();
            imageGraphics.translate(this.imageX, this.imageY);
            imageGraphics.scale(this.scaleX, this.scaleY);
            float alpha = 1.0f;
            Composite composite = imageGraphics.getComposite();
            if (composite instanceof AlphaComposite) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                alpha = alphaComposite.getAlpha();
            }
            if (this.opacity < alpha) {
                imageGraphics.setComposite(AlphaComposite.getInstance(3, this.opacity));
            }
            image.paint(imageGraphics);
            imageGraphics.dispose();
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Opacity out of range [0,1].");
        }
        this.opacity = opacity;
        this.repaintComponent();
    }

    public final void setOpacity(Number opacity) {
        if (opacity == null) {
            throw new IllegalArgumentException("opacity is null.");
        }
        this.setOpacity(opacity.floatValue());
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.layout();
        this.repaintComponent();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.layout();
        this.repaintComponent();
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.layout();
        this.repaintComponent();
    }

    public boolean getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        this.layout();
        this.repaintComponent();
    }

    @Override
    public void imageChanged(ImageView imageView, Image previousImage) {
        Image image;
        if (previousImage != null) {
            previousImage.getImageListeners().remove((Object)this.imageListener);
        }
        if ((image = imageView.getImage()) != null) {
            image.getImageListeners().add((Object)this.imageListener);
        }
        this.invalidateComponent();
    }

    @Override
    public void asynchronousChanged(ImageView imageView) {
    }
}

