/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.effects.FadeDecorator;
import org.apache.pivot.wtk.effects.ScaleDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quartic;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class CardPaneSkin
extends ContainerSkin
implements CardPaneListener {
    private Insets padding = Insets.NONE;
    private boolean sizeToSelection = false;
    private SelectionChangeEffect selectionChangeEffect = null;
    private int selectionChangeDuration = 250;
    private int selectionChangeRate = 30;
    private boolean circular = false;
    private SelectionChangeTransition selectionChangeTransition = null;
    private static final int DEFAULT_SELECTION_CHANGE_DURATION = 250;
    private static final int DEFAULT_SELECTION_CHANGE_RATE = 30;

    @Override
    public void install(Component component) {
        super.install(component);
        CardPane cardPane = (CardPane)component;
        cardPane.getCardPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        CardPane cardPane = (CardPane)this.getComponent();
        if (this.sizeToSelection) {
            if (this.selectionChangeTransition == null) {
                Component selectedCard = cardPane.getSelectedCard();
                if (selectedCard != null) {
                    preferredWidth = selectedCard.getPreferredWidth(height);
                }
            } else {
                float percentComplete = this.selectionChangeTransition.getPercentComplete();
                int previousWidth = this.selectionChangeTransition.fromCard == null ? 0 : this.selectionChangeTransition.fromCard.getPreferredWidth(height);
                int width = this.selectionChangeTransition.toCard == null ? 0 : this.selectionChangeTransition.toCard.getPreferredWidth(height);
                preferredWidth = previousWidth + (int)((float)(width - previousWidth) * percentComplete);
            }
        } else {
            for (Component card : cardPane) {
                preferredWidth = Math.max(preferredWidth, card.getPreferredWidth(height));
            }
            preferredWidth += this.padding.left + this.padding.right;
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        CardPane cardPane = (CardPane)this.getComponent();
        if (this.sizeToSelection) {
            if (this.selectionChangeTransition == null) {
                Component selectedCard = cardPane.getSelectedCard();
                if (selectedCard != null) {
                    preferredHeight = selectedCard.getPreferredHeight(width);
                }
            } else {
                float percentComplete = this.selectionChangeTransition.getPercentComplete();
                int previousHeight = this.selectionChangeTransition.fromCard == null ? 0 : this.selectionChangeTransition.fromCard.getPreferredHeight(width);
                int height = this.selectionChangeTransition.toCard == null ? 0 : this.selectionChangeTransition.toCard.getPreferredHeight(width);
                preferredHeight = previousHeight + (int)((float)(height - previousHeight) * percentComplete);
            }
        } else {
            for (Component card : cardPane) {
                preferredHeight = Math.max(preferredHeight, card.getPreferredHeight(width));
            }
            preferredHeight += this.padding.top + this.padding.bottom;
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        CardPane cardPane = (CardPane)this.getComponent();
        if (this.sizeToSelection) {
            if (this.selectionChangeTransition == null) {
                Component selectedCard = cardPane.getSelectedCard();
                if (selectedCard != null) {
                    Dimensions cardSize = selectedCard.getPreferredSize();
                    preferredWidth = cardSize.width;
                    preferredHeight = cardSize.height;
                }
            } else {
                int height;
                int width;
                int previousHeight;
                int previousWidth;
                float percentComplete = this.selectionChangeTransition.getPercentComplete();
                if (this.selectionChangeTransition.fromCard == null) {
                    previousWidth = 0;
                    previousHeight = 0;
                } else {
                    Dimensions fromSize = this.selectionChangeTransition.fromCard.getPreferredSize();
                    previousWidth = fromSize.width;
                    previousHeight = fromSize.height;
                }
                if (this.selectionChangeTransition.toCard == null) {
                    width = 0;
                    height = 0;
                } else {
                    Dimensions toSize = this.selectionChangeTransition.toCard.getPreferredSize();
                    width = toSize.width;
                    height = toSize.height;
                }
                preferredWidth = previousWidth + (int)((float)(width - previousWidth) * percentComplete);
                preferredHeight = previousHeight + (int)((float)(height - previousHeight) * percentComplete);
            }
        } else {
            for (Component card : cardPane) {
                Dimensions cardSize = card.getPreferredSize();
                preferredWidth = Math.max(cardSize.width, preferredWidth);
                preferredHeight = Math.max(cardSize.height, preferredHeight);
            }
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int width, int height) {
        int cardHeight;
        int cardWidth;
        CardPane cardPane;
        Component selectedCard;
        int baseline = -1;
        if (this.sizeToSelection && (selectedCard = (cardPane = (CardPane)this.getComponent()).getSelectedCard()) != null && (baseline = selectedCard.getBaseline(cardWidth = Math.max(width - (this.padding.left + this.padding.right), 0), cardHeight = Math.max(height - (this.padding.top + this.padding.bottom), 0))) != -1) {
            baseline += this.padding.top;
        }
        return baseline;
    }

    @Override
    public void layout() {
        CardPane cardPane = (CardPane)this.getComponent();
        int width = Math.max(this.getWidth() - (this.padding.left + this.padding.right), 0);
        int height = Math.max(this.getHeight() - (this.padding.top + this.padding.bottom), 0);
        for (Component card : cardPane) {
            card.setLocation(this.padding.left, this.padding.top);
            card.setSize(width, height);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public boolean getSizeToSelection() {
        return this.sizeToSelection;
    }

    public void setSizeToSelection(boolean sizeToSelection) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        this.sizeToSelection = sizeToSelection;
        this.invalidateComponent();
    }

    public SelectionChangeEffect getSelectionChangeEffect() {
        return this.selectionChangeEffect;
    }

    public void setSelectionChangeEffect(SelectionChangeEffect selectionChangeEffect) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        this.selectionChangeEffect = selectionChangeEffect;
    }

    public int getSelectionChangeDuration() {
        return this.selectionChangeDuration;
    }

    public void setSelectionChangeDuration(int selectionChangeDuration) {
        this.selectionChangeDuration = selectionChangeDuration;
    }

    public int getSelectionChangeRate() {
        return this.selectionChangeRate;
    }

    public void setSelectionChangeRate(int selectionChangeRate) {
        this.selectionChangeRate = selectionChangeRate;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean circular) {
        this.circular = circular;
    }

    @Override
    public void componentInserted(Container container, int index) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.componentInserted(container, index);
        CardPane cardPane = (CardPane)container;
        Component card = cardPane.get(index);
        card.setVisible(false);
        if (cardPane.getLength() == 1) {
            cardPane.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    @Override
    public void componentsRemoved(Container container, int index, Sequence<Component> removed) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.componentsRemoved(container, index, removed);
        int n = removed.getLength();
        for (int i = 0; i < n; ++i) {
            Component card = (Component)removed.get(i);
            card.setVisible(true);
        }
        this.invalidateComponent();
    }

    @Override
    public Vote previewSelectedIndexChange(CardPane cardPane, int selectedIndex) {
        if (cardPane.isShowing() && this.selectionChangeEffect != null && this.selectionChangeTransition == null) {
            int previousSelectedIndex = cardPane.getSelectedIndex();
            switch (this.selectionChangeEffect) {
                case CROSSFADE: {
                    this.selectionChangeTransition = new CrossfadeTransition(previousSelectedIndex, selectedIndex);
                    break;
                }
                case HORIZONTAL_SLIDE: 
                case VERTICAL_SLIDE: {
                    if (previousSelectedIndex == -1 || selectedIndex == -1) break;
                    this.selectionChangeTransition = new SlideTransition(previousSelectedIndex, selectedIndex);
                    break;
                }
                case HORIZONTAL_FLIP: {
                    if (previousSelectedIndex == -1 || selectedIndex == -1) break;
                    this.selectionChangeTransition = new FlipTransition(Orientation.HORIZONTAL, previousSelectedIndex, selectedIndex);
                    break;
                }
                case VERTICAL_FLIP: {
                    if (previousSelectedIndex == -1 || selectedIndex == -1) break;
                    this.selectionChangeTransition = new FlipTransition(Orientation.VERTICAL, previousSelectedIndex, selectedIndex);
                    break;
                }
                case ZOOM: {
                    if (previousSelectedIndex == -1 || selectedIndex == -1) break;
                    this.selectionChangeTransition = new ZoomTransition(previousSelectedIndex, selectedIndex);
                    break;
                }
            }
            if (this.selectionChangeTransition != null) {
                this.selectionChangeTransition.start(new TransitionListener(){

                    @Override
                    public void transitionCompleted(Transition transition) {
                        CardPane cardPaneLocal = (CardPane)CardPaneSkin.this.getComponent();
                        SelectionChangeTransition selectionChangeTransitionLocal = (SelectionChangeTransition)transition;
                        int selectedIndexLocal = cardPaneLocal.indexOf(selectionChangeTransitionLocal.toCard);
                        cardPaneLocal.setSelectedIndex(selectedIndexLocal);
                        CardPaneSkin.this.selectionChangeTransition = null;
                    }
                });
            }
        }
        Vote vote = this.selectionChangeTransition == null || !this.selectionChangeTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    @Override
    public void selectedIndexChangeVetoed(CardPane cardPane, Vote reason) {
        if (reason == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            if (this.sizeToSelection) {
                this.invalidateComponent();
            }
        }
    }

    @Override
    public void selectedIndexChanged(CardPane cardPane, int previousSelectedIndex) {
        int selectedIndex = cardPane.getSelectedIndex();
        if (selectedIndex != previousSelectedIndex) {
            if (selectedIndex != -1) {
                Component selectedCard = cardPane.get(selectedIndex);
                selectedCard.setVisible(true);
            }
            if (previousSelectedIndex != -1) {
                Component previousSelectedCard = cardPane.get(previousSelectedIndex);
                previousSelectedCard.setVisible(false);
            }
            if (selectedIndex == -1 || previousSelectedIndex == -1 || this.sizeToSelection) {
                this.invalidateComponent();
            }
        }
    }

    public class ZoomTransition
    extends CrossfadeTransition {
        private ScaleDecorator fromScaleDecorator;
        private ScaleDecorator toScaleDecorator;

        public ZoomTransition(int from, int to) {
            super(from, to);
            this.fromScaleDecorator = new ScaleDecorator();
            this.toScaleDecorator = new ScaleDecorator();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            if (this.fromCard != null) {
                this.fromCard.getDecorators().add(this.fromScaleDecorator);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().add(this.toScaleDecorator);
                this.toCard.setVisible(true);
            }
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            super.stop();
            if (this.fromCard != null) {
                this.fromCard.getDecorators().remove(this.fromScaleDecorator);
                this.fromCard.setVisible(false);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().remove(this.toScaleDecorator);
            }
        }

        @Override
        protected void update() {
            float percentComplete = this.getPercentComplete();
            if (this.direction == 1) {
                this.fromScaleDecorator.setScale(1.0f + percentComplete);
                this.toScaleDecorator.setScale(percentComplete);
            } else {
                this.fromScaleDecorator.setScale(1.0f - percentComplete);
                this.toScaleDecorator.setScale(2.0f - percentComplete);
            }
            super.update();
        }
    }

    public class FlipTransition
    extends SelectionChangeTransition {
        private Orientation orientation;
        private double theta;
        private ScaleDecorator scaleDecorator;

        public FlipTransition(Orientation orientation, int from, int to) {
            super(from, to);
            this.scaleDecorator = new ScaleDecorator();
            this.orientation = orientation;
        }

        @Override
        public void start(TransitionListener transitionListener) {
            this.theta = 0.0;
            CardPaneSkin.this.getComponent().getDecorators().add(this.scaleDecorator);
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            CardPaneSkin.this.getComponent().getDecorators().remove(this.scaleDecorator);
            super.stop();
        }

        @Override
        protected void update() {
            float percentComplete = this.getPercentComplete();
            if (percentComplete < 1.0f) {
                this.theta = Math.PI * (double)percentComplete;
                float scale = (float)Math.abs(Math.cos(this.theta));
                if (this.orientation == Orientation.HORIZONTAL) {
                    this.scaleDecorator.setScale(scale, 1.0f);
                } else {
                    this.scaleDecorator.setScale(1.0f, scale);
                }
                this.fromCard.setVisible(this.theta < 1.5707963267948966);
                this.toCard.setVisible(this.theta >= 1.5707963267948966);
                CardPaneSkin.this.repaintComponent();
            }
        }
    }

    public class SlideTransition
    extends SelectionChangeTransition {
        private Easing slideEasing;

        public SlideTransition(int from, int to) {
            super(from, to);
            this.slideEasing = new Quartic();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            this.toCard.setVisible(true);
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            this.fromCard.setVisible(false);
            super.stop();
        }

        @Override
        protected void update() {
            int width = CardPaneSkin.this.getWidth();
            int height = CardPaneSkin.this.getHeight();
            float percentComplete = this.slideEasing.easeOut(this.getElapsedTime(), 0.0f, 1.0f, this.getDuration());
            int dx = (int)((float)width * percentComplete) * -this.direction;
            int dy = (int)((float)height * percentComplete) * -this.direction;
            if (CardPaneSkin.this.selectionChangeEffect == SelectionChangeEffect.HORIZONTAL_SLIDE) {
                this.fromCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left + dx, ((CardPaneSkin)CardPaneSkin.this).padding.top);
                this.toCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left - width * -this.direction + dx, ((CardPaneSkin)CardPaneSkin.this).padding.top);
            } else {
                this.fromCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left, ((CardPaneSkin)CardPaneSkin.this).padding.top + dy);
                this.toCard.setLocation(((CardPaneSkin)CardPaneSkin.this).padding.left, ((CardPaneSkin)CardPaneSkin.this).padding.top - height * -this.direction + dy);
            }
        }
    }

    public class CrossfadeTransition
    extends SelectionChangeTransition {
        private FadeDecorator fadeOutDecorator;
        private FadeDecorator fadeInDecorator;

        public CrossfadeTransition(int from, int to) {
            super(from, to);
            this.fadeOutDecorator = new FadeDecorator();
            this.fadeInDecorator = new FadeDecorator();
        }

        @Override
        public void start(TransitionListener transitionListener) {
            if (this.fromCard != null) {
                this.fromCard.getDecorators().add(this.fadeOutDecorator);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().add(this.fadeInDecorator);
                this.toCard.setVisible(true);
            }
            super.start(transitionListener);
        }

        @Override
        public void stop() {
            super.stop();
            if (this.fromCard != null) {
                this.fromCard.getDecorators().remove(this.fadeOutDecorator);
                this.fromCard.setVisible(false);
            }
            if (this.toCard != null) {
                this.toCard.getDecorators().remove(this.fadeInDecorator);
            }
        }

        @Override
        protected void update() {
            float percentComplete = this.getPercentComplete();
            this.fadeOutDecorator.setOpacity(1.0f - percentComplete);
            this.fadeInDecorator.setOpacity(percentComplete);
            if (CardPaneSkin.this.sizeToSelection) {
                CardPaneSkin.this.invalidateComponent();
            } else {
                CardPaneSkin.this.repaintComponent();
            }
        }
    }

    public abstract class SelectionChangeTransition
    extends Transition {
        public final int from;
        public final int to;
        public final Component fromCard;
        public final Component toCard;
        public final int direction;

        public SelectionChangeTransition(int from, int to) {
            super(CardPaneSkin.this.selectionChangeDuration, CardPaneSkin.this.selectionChangeRate, false);
            this.from = from;
            this.to = to;
            CardPane cardPane = (CardPane)CardPaneSkin.this.getComponent();
            this.fromCard = from == -1 ? null : cardPane.get(from);
            this.toCard = to == -1 ? null : cardPane.get(to);
            int length = cardPane.getLength();
            this.direction = CardPaneSkin.this.circular && length >= 3 ? (from == length - 1 && to == 0 ? 1 : (from == 0 && to == length - 1 ? -1 : Integer.signum(to - from))) : Integer.signum(to - from);
        }
    }

    public static enum SelectionChangeEffect {
        CROSSFADE,
        HORIZONTAL_SLIDE,
        VERTICAL_SLIDE,
        HORIZONTAL_FLIP,
        VERTICAL_FLIP,
        ZOOM;

    }
}

