/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.content.TreeViewNodeRenderer;

public class TreeViewNodeEditor
extends Window
implements TreeView.NodeEditor {
    private TreeView treeView = null;
    private Sequence.Tree.Path path = null;
    private TextInput textInput = new TextInput();
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (window != TreeViewNodeEditor.this) {
                TreeViewNodeEditor.this.endEdit(true);
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            return window != TreeViewNodeEditor.this;
        }
    };

    public TreeViewNodeEditor() {
        this.setContent(this.textInput);
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public Sequence.Tree.Path getPath() {
        return this.path;
    }

    public TextInput getTextInput() {
        return this.textInput;
    }

    @Override
    public void beginEdit(TreeView treeViewArgument, Sequence.Tree.Path pathArgument) {
        this.treeView = treeViewArgument;
        this.path = pathArgument;
        List<?> treeData = treeViewArgument.getTreeData();
        TreeNode treeNode = (TreeNode)Sequence.Tree.get(treeData, (Sequence.Tree.Path)pathArgument);
        String text = treeNode.getText();
        this.textInput.setText(text != null ? text : "");
        this.textInput.selectAll();
        Bounds nodeBounds = treeViewArgument.getNodeBounds(pathArgument);
        int nodeIndent = treeViewArgument.getNodeIndent(pathArgument.getLength());
        nodeBounds = new Bounds(nodeBounds.x + nodeIndent, nodeBounds.y, nodeBounds.width - nodeIndent, nodeBounds.height);
        TreeViewNodeRenderer nodeRenderer = (TreeViewNodeRenderer)treeViewArgument.getNodeRenderer();
        nodeRenderer.render(treeNode, pathArgument, treeViewArgument.getRowIndex(pathArgument), treeViewArgument, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
        nodeRenderer.setSize(nodeBounds.width, nodeBounds.height);
        Bounds textBounds = nodeRenderer.getTextBounds();
        Insets padding = (Insets)this.textInput.getStyles().get("padding");
        Bounds editBounds = new Bounds(nodeBounds.x + textBounds.x - (padding.left + 1), nodeBounds.y, nodeBounds.width - textBounds.x + (padding.left + 1), nodeBounds.height);
        treeViewArgument.scrollAreaToVisible(editBounds.x, editBounds.y, textBounds.width + padding.left + 1, editBounds.height);
        editBounds = treeViewArgument.getVisibleArea(editBounds);
        Point location = treeViewArgument.mapPointToAncestor(treeViewArgument.getDisplay(), editBounds.x, editBounds.y);
        this.textInput.setPreferredWidth(editBounds.width);
        this.setLocation(location.x, location.y + (editBounds.height - this.getPreferredHeight(-1)) / 2);
        this.open(treeViewArgument.getWindow());
    }

    @Override
    public void endEdit(boolean result) {
        if (result) {
            List parentData;
            String text = this.textInput.getText();
            List treeData = this.treeView.getTreeData();
            TreeNode treeNode = (TreeNode)Sequence.Tree.get(treeData, (Sequence.Tree.Path)this.path);
            treeNode.setText(text);
            int n = this.path.getLength();
            if (n == 1) {
                parentData = treeData;
            } else {
                Sequence.Tree.Path parentPath = new Sequence.Tree.Path(this.path, n - 1);
                parentData = (List)Sequence.Tree.get(treeData, (Sequence.Tree.Path)parentPath);
            }
            if (parentData.getComparator() == null) {
                int index = this.path.get(n - 1);
                parentData.remove(index, 1);
                parentData.insert((Object)treeNode, index);
            } else {
                parentData.remove(this.path.get(n - 1).intValue(), 1);
                parentData.add((Object)treeNode);
                this.path = new Sequence.Tree.Path(this.path, n - 1);
                this.path.add(Integer.valueOf(parentData.indexOf((Object)treeNode)));
                this.treeView.setSelectedPath(this.path);
                this.treeView.scrollAreaToVisible(this.treeView.getNodeBounds(this.path));
            }
        }
        this.getOwner().moveToFront();
        this.treeView.requestFocus();
        this.treeView = null;
        this.path = null;
        this.close();
    }

    @Override
    public boolean isEditing() {
        return this.treeView != null;
    }

    @Override
    public void open(Display display, Window owner) {
        if (this.treeView == null) {
            throw new IllegalStateException();
        }
        super.open(display, owner);
        display.getContainerMouseListeners().add((Object)this.displayMouseHandler);
        this.requestFocus();
    }

    @Override
    public void close() {
        Display display = this.getDisplay();
        display.getContainerMouseListeners().remove((Object)this.displayMouseHandler);
        super.close();
    }

    @Override
    public boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed;
        if (keyCode == 10) {
            this.endEdit(true);
            consumed = true;
        } else if (keyCode == 27) {
            this.endEdit(false);
            consumed = true;
        } else {
            consumed = false;
        }
        return consumed;
    }
}

