/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.CardPaneSkin;

public class TableViewRowEditor
extends Window
implements TableView.RowEditor {
    private TableView tableView = null;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private ScrollPane tableViewScrollPane = null;
    private ScrollPane scrollPane = new ScrollPane(ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.FILL);
    private CardPane cardPane = new CardPane();
    private TablePane tablePane = new TablePane();
    private TablePane.Row editorRow = new TablePane.Row();
    private RowImage rowImage = new RowImage();
    private HashMap<String, Component> cellEditors = new HashMap();
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            boolean consumed;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (!(window == TableViewRowEditor.this || window != null && TableViewRowEditor.this.isOwner(window))) {
                TableViewRowEditor.this.endEdit(true);
                consumed = true;
            } else {
                consumed = false;
            }
            return consumed;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            return window != TableViewRowEditor.this;
        }
    };
    private static final int IMAGE_CARD_INDEX = 0;
    private static final int EDITOR_CARD_INDEX = 1;

    public TableViewRowEditor() {
        this.setContent(this.scrollPane);
        this.scrollPane.setView(this.cardPane);
        this.scrollPane.getViewportListeners().add((Object)new ViewportListener.Adapter(){

            @Override
            public void scrollLeftChanged(Viewport viewport, int previousScrollLeft) {
                if (TableViewRowEditor.this.tableViewScrollPane != null) {
                    TableViewRowEditor.this.tableViewScrollPane.setScrollLeft(viewport.getScrollLeft());
                }
            }
        });
        this.cardPane.add(new ImageView(this.rowImage));
        this.cardPane.add(this.tablePane);
        this.cardPane.getCardPaneListeners().add((Object)new CardPaneListener.Adapter(){

            @Override
            public void selectedIndexChanged(CardPane cardPaneArgument, int previousSelectedIndex) {
                if (previousSelectedIndex == 0) {
                    TableViewRowEditor.this.editorRow.get(TableViewRowEditor.this.columnIndex).requestFocus();
                } else {
                    TableViewRowEditor.this.endEdit(false);
                }
            }
        });
        this.tablePane.getStyles().put("horizontalSpacing", (Object)1);
        this.tablePane.getRows().add(this.editorRow);
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Dictionary<String, Component> getCellEditors() {
        return this.cellEditors;
    }

    @Override
    public void beginEdit(TableView tableViewArgument, int rowIndexArgument, int columnIndexArgument) {
        this.tableView = tableViewArgument;
        this.rowIndex = rowIndexArgument;
        this.columnIndex = columnIndexArgument;
        Container tableViewParent = tableViewArgument.getParent();
        this.tableViewScrollPane = tableViewParent instanceof ScrollPane ? (ScrollPane)tableViewParent : null;
        TableView.ColumnSequence tableViewColumns = tableViewArgument.getColumns();
        TablePane.ColumnSequence tablePaneColumns = this.tablePane.getColumns();
        int n = tableViewColumns.getLength();
        for (int i = 0; i < n; ++i) {
            TablePane.Column tablePaneColumn = new TablePane.Column();
            tablePaneColumn.setWidth(tableViewArgument.getColumnBounds((int)i).width);
            tablePaneColumns.add(tablePaneColumn);
            String columnName = tableViewColumns.get(i).getName();
            Component editorComponent = null;
            if (columnName != null) {
                editorComponent = (Component)this.cellEditors.get((Object)columnName);
            }
            if (editorComponent == null) {
                TextInput editorTextInput = new TextInput();
                editorTextInput.setTextKey(columnName);
                editorTextInput.setEnabled(false);
                editorTextInput.setTextBindType(BindType.LOAD);
                editorComponent = editorTextInput;
            }
            this.editorRow.add(editorComponent);
        }
        List<?> tableData = tableViewArgument.getTableData();
        Object tableRow = tableData.get(rowIndexArgument);
        this.tablePane.load(tableRow);
        Bounds rowBounds = tableViewArgument.getRowBounds(rowIndexArgument);
        this.rowImage.bounds = rowBounds;
        tableViewArgument.scrollAreaToVisible(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
        rowBounds = tableViewArgument.getVisibleArea(rowBounds);
        Point location = tableViewArgument.mapPointToAncestor(tableViewArgument.getDisplay(), rowBounds.x, rowBounds.y);
        this.setPreferredWidth(rowBounds.width);
        this.setLocation(location.x, location.y + (rowBounds.height - this.getPreferredHeight(-1)) / 2);
        if (this.tableViewScrollPane != null) {
            this.scrollPane.setScrollLeft(this.tableViewScrollPane.getScrollLeft());
        }
        this.open(tableViewArgument.getWindow());
        this.cardPane.setSelectedIndex(1);
    }

    @Override
    public void endEdit(boolean result) {
        if (result) {
            List<?> tableData = this.tableView.getTableData();
            Object tableRow = tableData.get(this.rowIndex);
            this.tablePane.store(tableRow);
            if (tableData.getComparator() == null) {
                tableData.update(this.rowIndex, tableRow);
            } else {
                tableData.remove(this.rowIndex, 1);
                tableData.add(tableRow);
                this.rowIndex = tableData.indexOf(tableRow);
                this.tableView.setSelectedIndex(this.rowIndex);
                this.tableView.scrollAreaToVisible(this.tableView.getRowBounds(this.rowIndex));
            }
        }
        if (this.cardPane.getSelectedIndex() == 1) {
            this.cardPane.setSelectedIndex(0);
        } else {
            TablePane.ColumnSequence tablePaneColumns = this.tablePane.getColumns();
            tablePaneColumns.remove(0, tablePaneColumns.getLength());
            this.editorRow.remove(0, this.editorRow.getLength());
            this.getOwner().moveToFront();
            this.tableView.requestFocus();
            this.tableView = null;
            this.rowIndex = -1;
            this.columnIndex = -1;
            this.tableViewScrollPane = null;
            this.close();
        }
    }

    @Override
    public boolean isEditing() {
        return this.tableView != null;
    }

    public CardPaneSkin.SelectionChangeEffect getEditEffect() {
        return (CardPaneSkin.SelectionChangeEffect)((Object)this.cardPane.getStyles().get("selectionChangeEffect"));
    }

    public void setEditEffect(CardPaneSkin.SelectionChangeEffect editEffect) {
        this.cardPane.getStyles().put("selectionChangeEffect", (Object)editEffect);
    }

    public int getEditEffectDuration() {
        return (Integer)this.cardPane.getStyles().get("selectionChangeDuration");
    }

    public void setEditEffectDuration(int effectDuration) {
        this.cardPane.getStyles().put("selectionChangeDuration", (Object)effectDuration);
    }

    public int getEditEffectRate() {
        return (Integer)this.cardPane.getStyles().get("selectionChangeRate");
    }

    public void setEditEffectRate(int effectRate) {
        this.cardPane.getStyles().put("selectionChangeRate", (Object)effectRate);
    }

    @Override
    public void open(Display display, Window owner) {
        if (this.tableView == null) {
            throw new IllegalStateException();
        }
        super.open(display, owner);
        display.getContainerMouseListeners().add((Object)this.displayMouseHandler);
    }

    @Override
    public void close() {
        Display display = this.getDisplay();
        display.getContainerMouseListeners().remove((Object)this.displayMouseHandler);
        super.close();
    }

    @Override
    public boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed;
        if (keyCode == 10) {
            this.endEdit(true);
            consumed = true;
        } else if (keyCode == 27) {
            this.endEdit(false);
            consumed = true;
        } else {
            consumed = false;
        }
        return consumed;
    }

    private class RowImage
    extends Image {
        private Bounds bounds = new Bounds(0, 0, 0, 0);

        private RowImage() {
        }

        @Override
        public int getWidth() {
            return this.bounds.width;
        }

        @Override
        public int getHeight() {
            return this.bounds.height;
        }

        @Override
        public void paint(Graphics2D graphics) {
            graphics.translate(-this.bounds.x, -this.bounds.y);
            graphics.clipRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            TableViewRowEditor.this.tableView.paint(graphics);
        }
    }
}

