/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.TableViewHeaderData;
import org.apache.pivot.wtk.media.Image;

public class TableViewHeaderDataRenderer
extends BoxPane
implements TableView.HeaderDataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();

    public TableViewHeaderDataRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("padding", (Object)new Insets(1, 2, 1, 2));
        this.add(this.imageView);
        this.add(this.label);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object data, int columnIndex, TableViewHeader tableViewHeader, String columnName, boolean highlighted) {
        Image icon = null;
        String text = null;
        if (data instanceof TableViewHeaderData) {
            TableViewHeaderData tableViewHeaderData = (TableViewHeaderData)data;
            icon = tableViewHeaderData.getIcon();
        } else if (data instanceof Image) {
            icon = (Image)data;
        }
        text = this.toString(data);
        this.imageView.setImage(icon);
        if (icon == null) {
            this.imageView.setVisible(false);
        } else {
            this.imageView.setVisible(true);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(tableViewHeader.isEnabled() ? 1.0f : 0.5f));
        }
        this.label.setText(text != null ? text : "");
        if (text == null) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
            Component.StyleDictionary labelStyles = this.label.getStyles();
            Object labelFont = tableViewHeader.getStyles().get("font");
            if (labelFont instanceof Font) {
                labelStyles.put("font", labelFont);
            }
            Object color = null;
            color = tableViewHeader.isEnabled() ? tableViewHeader.getStyles().get("color") : tableViewHeader.getStyles().get("disabledColor");
            if (color instanceof Color) {
                labelStyles.put("color", color);
            }
        }
    }

    @Override
    public String toString(Object data) {
        String string = null;
        if (data instanceof TableViewHeaderData) {
            TableViewHeaderData tableViewHeaderData = (TableViewHeaderData)data;
            string = tableViewHeaderData.getText();
        } else if (!(data instanceof Image) && data != null) {
            string = data.toString();
        }
        return string;
    }
}

