/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TextDecoration;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.media.Image;

public class LinkButtonDataRenderer
extends TablePane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();

    public LinkButtonDataRenderer() {
        this.getStyles().put("horizontalSpacing", (Object)4);
        this.getColumns().add(new TablePane.Column());
        this.getColumns().add(new TablePane.Column(1, true));
        TablePane.Row row = new TablePane.Row();
        row.add(this.imageView);
        row.add(this.label);
        this.getRows().add(row);
        this.label.getStyles().put("wrapText", (Object)true);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object data, Button button, boolean highlighted) {
        Image icon = null;
        String text = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            icon = buttonData.getIcon();
        } else if (data instanceof Image) {
            icon = (Image)data;
        }
        text = this.toString(data);
        if (icon == null) {
            this.imageView.setVisible(false);
        } else {
            this.imageView.setVisible(true);
            this.imageView.setImage(icon);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
        }
        this.label.setText(text != null ? text : "");
        if (text == null) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
            Font font = (Font)button.getStyles().get("font");
            this.label.getStyles().put("font", (Object)font);
            Color color = button.isEnabled() ? (Color)button.getStyles().get("color") : (Color)button.getStyles().get("disabledColor");
            this.label.getStyles().put("color", (Object)color);
        }
        this.label.getStyles().put("textDecoration", (Object)(highlighted ? TextDecoration.UNDERLINE : null));
    }

    @Override
    public String toString(Object data) {
        String string = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            string = buttonData.getText();
        } else if (!(data instanceof Image) && data != null) {
            string = data.toString();
        }
        return string;
    }
}

