/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewHeaderListener;
import org.apache.pivot.wtk.TableViewHeaderPressListener;
import org.apache.pivot.wtk.WTKListenerList;

public class TableViewHeader
extends Component {
    private TableView tableView;
    private SortMode sortMode = SortMode.NONE;
    private TableViewHeaderListenerList tableViewHeaderListeners = new TableViewHeaderListenerList();
    private TableViewHeaderPressListenerList tableViewHeaderPressListeners = new TableViewHeaderPressListenerList();

    public TableViewHeader() {
        this(null);
    }

    public TableViewHeader(TableView tableView) {
        this.installSkin(TableViewHeader.class);
        this.setTableView(tableView);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public void setTableView(TableView tableView) {
        TableView previousTableView = this.tableView;
        if (previousTableView != tableView) {
            this.tableView = tableView;
            this.tableViewHeaderListeners.tableViewChanged(this, previousTableView);
        }
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        if (sortMode == null) {
            throw new IllegalArgumentException();
        }
        SortMode previousSortMode = this.sortMode;
        if (previousSortMode != sortMode) {
            this.sortMode = sortMode;
            this.tableViewHeaderListeners.sortModeChanged(this, previousSortMode);
        }
    }

    public void pressHeader(int index) {
        this.tableViewHeaderPressListeners.headerPressed(this, index);
    }

    public int getHeaderAt(int x) {
        Skin tableViewHeaderSkin = (Skin)((Object)this.getSkin());
        return tableViewHeaderSkin.getHeaderAt(x);
    }

    public Bounds getHeaderBounds(int index) {
        Skin tableViewHeaderSkin = (Skin)((Object)this.getSkin());
        return tableViewHeaderSkin.getHeaderBounds(index);
    }

    public ListenerList<TableViewHeaderListener> getTableViewHeaderListeners() {
        return this.tableViewHeaderListeners;
    }

    public ListenerList<TableViewHeaderPressListener> getTableViewHeaderPressListeners() {
        return this.tableViewHeaderPressListeners;
    }

    private static class TableViewHeaderPressListenerList
    extends WTKListenerList<TableViewHeaderPressListener>
    implements TableViewHeaderPressListener {
        private TableViewHeaderPressListenerList() {
        }

        @Override
        public void headerPressed(TableViewHeader tableViewHeader, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewHeaderPressListener listener = (TableViewHeaderPressListener)i$.next();
                listener.headerPressed(tableViewHeader, index);
            }
        }
    }

    private static class TableViewHeaderListenerList
    extends WTKListenerList<TableViewHeaderListener>
    implements TableViewHeaderListener {
        private TableViewHeaderListenerList() {
        }

        @Override
        public void tableViewChanged(TableViewHeader tableViewHeader, TableView previousTableView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewHeaderListener listener = (TableViewHeaderListener)i$.next();
                listener.tableViewChanged(tableViewHeader, previousTableView);
            }
        }

        @Override
        public void sortModeChanged(TableViewHeader tableViewHeader, SortMode previousSortMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TableViewHeaderListener listener = (TableViewHeaderListener)i$.next();
                listener.sortModeChanged(tableViewHeader, previousSortMode);
            }
        }
    }

    public static interface Skin {
        public int getHeaderAt(int var1);

        public Bounds getHeaderBounds(int var1);
    }

    public static enum SortMode {
        NONE,
        SINGLE_COLUMN,
        MULTI_COLUMN;

    }
}

