/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuPopupListener;
import org.apache.pivot.wtk.MenuPopupStateListener;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.Window;

@DefaultProperty(value="menu")
public class MenuPopup
extends Window {
    private Menu menu;
    private boolean contextMenu = false;
    private boolean closing = false;
    private MenuPopupListenerList menuPopupListeners = new MenuPopupListenerList();
    private MenuPopupStateListenerList menuPopupStateListeners = new MenuPopupStateListenerList();

    public MenuPopup() {
        this(null);
    }

    public MenuPopup(Menu menu) {
        this.setMenu(menu);
        this.installSkin(MenuPopup.class);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        Menu previousMenu = this.menu;
        if (previousMenu != menu) {
            this.menu = menu;
            this.menuPopupListeners.menuChanged(this, previousMenu);
        }
    }

    public boolean isContextMenu() {
        return this.contextMenu;
    }

    public final void open(Display display, int x, int y) {
        this.open(display, null, x, y);
    }

    public final void open(Display display, Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.open(display, null, location.x, location.y);
    }

    public final void open(Window owner, int x, int y) {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        this.open(owner.getDisplay(), owner, x, y);
    }

    public final void open(Window owner, Point location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.open(owner, location.x, location.y);
    }

    public void open(Display display, Window owner, int x, int y) {
        this.contextMenu = true;
        this.setLocation(x, y);
        super.open(display, owner);
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean immediate) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.menuPopupStateListeners.previewMenuPopupClose(this, immediate);
            if (vote == Vote.APPROVE) {
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.menuPopupStateListeners.menuPopupClosed(this);
                }
            } else if (vote == Vote.DENY) {
                this.closing = false;
                this.menuPopupStateListeners.menuPopupCloseVetoed(this, vote);
            }
        }
        if (this.isClosed()) {
            this.contextMenu = false;
        }
    }

    public ListenerList<MenuPopupListener> getMenuPopupListeners() {
        return this.menuPopupListeners;
    }

    public ListenerList<MenuPopupStateListener> getMenuPopupStateListeners() {
        return this.menuPopupStateListeners;
    }

    private static class MenuPopupStateListenerList
    extends WTKListenerList<MenuPopupStateListener>
    implements MenuPopupStateListener {
        private MenuPopupStateListenerList() {
        }

        @Override
        public Vote previewMenuPopupClose(MenuPopup menuPopup, boolean immediate) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuPopupStateListener listener = (MenuPopupStateListener)i$.next();
                vote = vote.tally(listener.previewMenuPopupClose(menuPopup, immediate));
            }
            return vote;
        }

        @Override
        public void menuPopupCloseVetoed(MenuPopup menuPopup, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuPopupStateListener listener = (MenuPopupStateListener)i$.next();
                listener.menuPopupCloseVetoed(menuPopup, reason);
            }
        }

        @Override
        public void menuPopupClosed(MenuPopup menuPopup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuPopupStateListener listener = (MenuPopupStateListener)i$.next();
                listener.menuPopupClosed(menuPopup);
            }
        }
    }

    private static class MenuPopupListenerList
    extends WTKListenerList<MenuPopupListener>
    implements MenuPopupListener {
        private MenuPopupListenerList() {
        }

        @Override
        public void menuChanged(MenuPopup menuPopup, Menu previousMenu) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuPopupListener listener = (MenuPopupListener)i$.next();
                listener.menuChanged(menuPopup, previousMenu);
            }
        }
    }
}

