/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Color;
import java.util.Iterator;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.ColorChooserButtonBindingListener;
import org.apache.pivot.wtk.ColorChooserButtonSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ListButtonColorItemRenderer;

public class ColorChooserButton
extends Button {
    private Color selectedColor = null;
    private String selectedColorKey = null;
    private BindType selectedColorBindType = BindType.BOTH;
    private ColorChooser.SelectedColorBindMapping selectedColorBindMapping = null;
    private ColorChooserButtonSelectionListenerList colorChooserButtonSelectionListeners = new ColorChooserButtonSelectionListenerList();
    private ColorChooserButtonBindingListenerList colorChooserButtonBindingListeners = new ColorChooserButtonBindingListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ListButtonColorItemRenderer();

    public ColorChooserButton() {
        this(null);
    }

    public ColorChooserButton(Object buttonData) {
        super(buttonData);
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installSkin(ColorChooserButton.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Window getListPopup() {
        return ((Skin)((Object)this.getSkin())).getColorChooserPopup();
    }

    @Override
    public void setToggleButton(boolean toggleButton) {
        throw new UnsupportedOperationException("Color chooser buttons cannot be toggle buttons.");
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        Color previousSelectedColor = this.selectedColor;
        if (!(previousSelectedColor == selectedColor || previousSelectedColor != null && previousSelectedColor.equals(selectedColor))) {
            this.selectedColor = selectedColor;
            this.colorChooserButtonSelectionListeners.selectedColorChanged(this, previousSelectedColor);
        }
    }

    public final void setSelectedColor(String selectedColor) {
        if (selectedColor == null) {
            throw new IllegalArgumentException("selectedColor is null.");
        }
        this.setSelectedColor(Color.decode(selectedColor));
    }

    public String getSelectedColorKey() {
        return this.selectedColorKey;
    }

    public void setSelectedColorKey(String selectedColorKey) {
        String previousSelectedColorKey = this.selectedColorKey;
        if (previousSelectedColorKey != selectedColorKey) {
            this.selectedColorKey = selectedColorKey;
            this.colorChooserButtonBindingListeners.selectedColorKeyChanged(this, previousSelectedColorKey);
        }
    }

    public BindType getSelectedColorBindType() {
        return this.selectedColorBindType;
    }

    public void setSelectedColorBindType(BindType selectedColorBindType) {
        if (selectedColorBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedColorBindType = this.selectedColorBindType;
        if (previousSelectedColorBindType != selectedColorBindType) {
            this.selectedColorBindType = selectedColorBindType;
            this.colorChooserButtonBindingListeners.selectedColorBindTypeChanged(this, previousSelectedColorBindType);
        }
    }

    public ColorChooser.SelectedColorBindMapping getSelectedColorBindMapping() {
        return this.selectedColorBindMapping;
    }

    public void setSelectedColorBindMapping(ColorChooser.SelectedColorBindMapping bindMapping) {
        ColorChooser.SelectedColorBindMapping previousSelectedColorBindMapping = this.selectedColorBindMapping;
        if (previousSelectedColorBindMapping != bindMapping) {
            this.selectedColorBindMapping = bindMapping;
            this.colorChooserButtonBindingListeners.selectedColorBindMappingChanged(this, previousSelectedColorBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.selectedColorKey != null && JSON.containsKey((Object)context, (String)this.selectedColorKey) && this.selectedColorBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.selectedColorKey);
            Color selectedColorLocal = null;
            if (value instanceof Color) {
                selectedColorLocal = (Color)value;
            } else if (this.selectedColorBindMapping == null) {
                if (value != null) {
                    selectedColorLocal = Color.decode(value.toString());
                }
            } else {
                selectedColorLocal = this.selectedColorBindMapping.toColor(value);
            }
            this.setSelectedColor(selectedColorLocal);
        }
    }

    @Override
    public void store(Object context) {
        if (this.selectedColorKey != null && this.selectedColorBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.selectedColorKey, (Object)(this.selectedColorBindMapping == null ? this.selectedColor : this.selectedColorBindMapping.valueOf(this.selectedColor)));
        }
    }

    @Override
    public void clear() {
        if (this.selectedColorKey != null) {
            this.setSelectedColor((Color)null);
        }
    }

    public ListenerList<ColorChooserButtonSelectionListener> getColorChooserButtonSelectionListeners() {
        return this.colorChooserButtonSelectionListeners;
    }

    public ListenerList<ColorChooserButtonBindingListener> getColorChooserButtonBindingListeners() {
        return this.colorChooserButtonBindingListeners;
    }

    public static interface Skin {
        public Window getColorChooserPopup();
    }

    private static class ColorChooserButtonBindingListenerList
    extends WTKListenerList<ColorChooserButtonBindingListener>
    implements ColorChooserButtonBindingListener {
        private ColorChooserButtonBindingListenerList() {
        }

        @Override
        public void selectedColorKeyChanged(ColorChooserButton colorChooserButton, String previousSelectedColorKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserButtonBindingListener listener = (ColorChooserButtonBindingListener)i$.next();
                listener.selectedColorKeyChanged(colorChooserButton, previousSelectedColorKey);
            }
        }

        @Override
        public void selectedColorBindTypeChanged(ColorChooserButton colorChooserButton, BindType previousSelectedColorBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserButtonBindingListener listener = (ColorChooserButtonBindingListener)i$.next();
                listener.selectedColorBindTypeChanged(colorChooserButton, previousSelectedColorBindType);
            }
        }

        @Override
        public void selectedColorBindMappingChanged(ColorChooserButton colorChooserButton, ColorChooser.SelectedColorBindMapping previousSelectedColorBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserButtonBindingListener listener = (ColorChooserButtonBindingListener)i$.next();
                listener.selectedColorBindMappingChanged(colorChooserButton, previousSelectedColorBindMapping);
            }
        }
    }

    private static class ColorChooserButtonSelectionListenerList
    extends WTKListenerList<ColorChooserButtonSelectionListener>
    implements ColorChooserButtonSelectionListener {
        private ColorChooserButtonSelectionListenerList() {
        }

        @Override
        public void selectedColorChanged(ColorChooserButton colorChooserButton, Color previousSelectedColor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ColorChooserButtonSelectionListener listener = (ColorChooserButtonSelectionListener)i$.next();
                listener.selectedColorChanged(colorChooserButton, previousSelectedColor);
            }
        }
    }
}

