/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.CardPaneListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.WTKListenerList;

public class CardPane
extends Container {
    private int selectedIndex = -1;
    private CardPaneListenerList cardPaneListeners = new CardPaneListenerList();

    public CardPane() {
        this.installSkin(CardPane.class);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        CardPane.indexBoundsCheck("selectedIndex", selectedIndex, -1, this.getLength() - 1);
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            Vote vote = this.cardPaneListeners.previewSelectedIndexChange(this, selectedIndex);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = selectedIndex;
                this.cardPaneListeners.selectedIndexChanged(this, previousSelectedIndex);
            } else {
                this.cardPaneListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedCard() {
        return this.selectedIndex == -1 ? null : this.get(this.selectedIndex);
    }

    @Override
    public void insert(Component component, int index) {
        int previousSelectedIndex = this.selectedIndex;
        if (this.selectedIndex >= index) {
            ++this.selectedIndex;
        }
        super.insert(component, index);
        if (this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
            this.cardPaneListeners.selectedIndexChanged(this, this.selectedIndex);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int previousSelectedIndex = this.selectedIndex;
        if (this.selectedIndex >= index) {
            this.selectedIndex = this.selectedIndex < index + count ? -1 : (this.selectedIndex -= count);
        }
        Sequence<Component> removed = super.remove(index, count);
        if (this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
            this.cardPaneListeners.selectedIndexChanged(this, this.selectedIndex);
        }
        return removed;
    }

    public ListenerList<CardPaneListener> getCardPaneListeners() {
        return this.cardPaneListeners;
    }

    private static class CardPaneListenerList
    extends WTKListenerList<CardPaneListener>
    implements CardPaneListener {
        private CardPaneListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(CardPane cardPane, int selectedIndex) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CardPaneListener listener = (CardPaneListener)i$.next();
                vote = vote.tally(listener.previewSelectedIndexChange(cardPane, selectedIndex));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(CardPane cardPane, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CardPaneListener listener = (CardPaneListener)i$.next();
                listener.selectedIndexChangeVetoed(cardPane, reason);
            }
        }

        @Override
        public void selectedIndexChanged(CardPane cardPane, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CardPaneListener listener = (CardPaneListener)i$.next();
                listener.selectedIndexChanged(cardPane, previousSelectedIndex);
            }
        }
    }
}

