/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BoxPaneListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.WTKListenerList;

public class BoxPane
extends Container {
    private Orientation orientation = null;
    private BoxPaneListenerList boxPaneListeners = new BoxPaneListenerList();

    public BoxPane() {
        this(Orientation.HORIZONTAL);
    }

    public BoxPane(Orientation orientation) {
        this.setOrientation(orientation);
        this.installSkin(BoxPane.class);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException();
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.boxPaneListeners.orientationChanged(this);
        }
    }

    public ListenerList<BoxPaneListener> getBoxPaneListeners() {
        return this.boxPaneListeners;
    }

    private static class BoxPaneListenerList
    extends WTKListenerList<BoxPaneListener>
    implements BoxPaneListener {
        private BoxPaneListenerList() {
        }

        @Override
        public void orientationChanged(BoxPane boxPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                BoxPaneListener listener = (BoxPaneListener)i$.next();
                listener.orientationChanged(boxPane);
            }
        }
    }
}

