/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.AccordionAttributeListener;
import org.apache.pivot.wtk.AccordionListener;
import org.apache.pivot.wtk.AccordionSelectionListener;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.content.AccordionHeaderDataRenderer;

@DefaultProperty(value="panels")
public class Accordion
extends Container {
    private ArrayList<Component> panels = new ArrayList();
    private PanelSequence panelSequence = new PanelSequence();
    private int selectedIndex = -1;
    private Button.DataRenderer headerDataRenderer = DEFAULT_HEADER_DATA_RENDERER;
    private AccordionListenerList accordionListeners = new AccordionListenerList();
    private AccordionSelectionListenerList accordionSelectionListeners = new AccordionSelectionListenerList();
    private AccordionAttributeListenerList accordionAttributeListeners = new AccordionAttributeListenerList();
    private static final Button.DataRenderer DEFAULT_HEADER_DATA_RENDERER = new AccordionHeaderDataRenderer();

    public Accordion() {
        this.installSkin(Accordion.class);
    }

    public PanelSequence getPanels() {
        return this.panelSequence;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        Accordion.indexBoundsCheck("selectedIndex", selectedIndex, -1, this.panels.getLength() - 1);
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            Vote vote = this.accordionSelectionListeners.previewSelectedIndexChange(this, selectedIndex);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = selectedIndex;
                this.accordionSelectionListeners.selectedIndexChanged(this, previousSelectedIndex);
            } else {
                this.accordionSelectionListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedPanel() {
        return this.selectedIndex == -1 ? null : (Component)this.panels.get(this.selectedIndex);
    }

    public Button.DataRenderer getHeaderDataRenderer() {
        return this.headerDataRenderer;
    }

    public void setHeaderDataRenderer(Button.DataRenderer headerDataRenderer) {
        if (headerDataRenderer == null) {
            throw new IllegalArgumentException();
        }
        Button.DataRenderer previousHeaderDataRenderer = this.headerDataRenderer;
        if (previousHeaderDataRenderer != headerDataRenderer) {
            this.headerDataRenderer = headerDataRenderer;
            this.accordionListeners.headerDataRendererChanged(this, previousHeaderDataRenderer);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (this.panels.indexOf((Object)component) < 0) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<AccordionListener> getAccordionListeners() {
        return this.accordionListeners;
    }

    public ListenerList<AccordionSelectionListener> getAccordionSelectionListeners() {
        return this.accordionSelectionListeners;
    }

    public ListenerList<AccordionAttributeListener> getAccordionAttributeListeners() {
        return this.accordionAttributeListeners;
    }

    public static Object getHeaderData(Component component) {
        return component.getAttribute(Attribute.HEADER_DATA);
    }

    public static void setHeaderData(Component component, Object headerData) {
        Container parent;
        Object previousHeaderData = component.setAttribute(Attribute.HEADER_DATA, headerData);
        if (previousHeaderData != headerData && (parent = component.getParent()) instanceof Accordion) {
            Accordion accordion = (Accordion)parent;
            accordion.accordionAttributeListeners.headerDataChanged(accordion, component, previousHeaderData);
        }
    }

    public static String getTooltipText(Component component) {
        return (String)component.getAttribute(Attribute.TOOLTIP_TEXT);
    }

    public static void setTooltipText(Component component, String tooltipText) {
        Container parent;
        String previousTooltipText = (String)component.setAttribute(Attribute.TOOLTIP_TEXT, tooltipText);
        if (previousTooltipText != tooltipText && (parent = component.getParent()) instanceof Accordion) {
            Accordion accordion = (Accordion)parent;
            accordion.accordionAttributeListeners.tooltipTextChanged(accordion, component, previousTooltipText);
        }
    }

    private static class AccordionAttributeListenerList
    extends WTKListenerList<AccordionAttributeListener>
    implements AccordionAttributeListener {
        private AccordionAttributeListenerList() {
        }

        @Override
        public void headerDataChanged(Accordion accordion, Component component, Object previousHeaderData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionAttributeListener listener = (AccordionAttributeListener)i$.next();
                listener.headerDataChanged(accordion, component, previousHeaderData);
            }
        }

        @Override
        public void tooltipTextChanged(Accordion accordion, Component component, String previousTooltipText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionAttributeListener listener = (AccordionAttributeListener)i$.next();
                listener.tooltipTextChanged(accordion, component, previousTooltipText);
            }
        }
    }

    private static class AccordionSelectionListenerList
    extends WTKListenerList<AccordionSelectionListener>
    implements AccordionSelectionListener {
        private AccordionSelectionListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(Accordion accordion, int selectedIndex) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionSelectionListener listener = (AccordionSelectionListener)i$.next();
                vote = vote.tally(listener.previewSelectedIndexChange(accordion, selectedIndex));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(Accordion accordion, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionSelectionListener listener = (AccordionSelectionListener)i$.next();
                listener.selectedIndexChangeVetoed(accordion, reason);
            }
        }

        @Override
        public void selectedIndexChanged(Accordion accordion, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionSelectionListener listener = (AccordionSelectionListener)i$.next();
                listener.selectedIndexChanged(accordion, previousSelectedIndex);
            }
        }
    }

    private static class AccordionListenerList
    extends WTKListenerList<AccordionListener>
    implements AccordionListener {
        private AccordionListenerList() {
        }

        @Override
        public void panelInserted(Accordion accordion, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionListener listener = (AccordionListener)i$.next();
                listener.panelInserted(accordion, index);
            }
        }

        @Override
        public void panelsRemoved(Accordion accordion, int index, Sequence<Component> panels) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionListener listener = (AccordionListener)i$.next();
                listener.panelsRemoved(accordion, index, panels);
            }
        }

        @Override
        public void headerDataRendererChanged(Accordion accordion, Button.DataRenderer previousHeaderDataRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AccordionListener listener = (AccordionListener)i$.next();
                listener.headerDataRendererChanged(accordion, previousHeaderDataRenderer);
            }
        }
    }

    private static enum Attribute {
        HEADER_DATA,
        TOOLTIP_TEXT;

    }

    public final class PanelSequence
    implements Sequence<Component>,
    Iterable<Component> {
        private PanelSequence() {
        }

        public int add(Component panel) {
            int index = this.getLength();
            this.insert(panel, index);
            return index;
        }

        public void insert(Component panel, int index) {
            if (panel == null) {
                throw new IllegalArgumentException("panel is null.");
            }
            Accordion.this.add(panel);
            Accordion.this.panels.insert((Object)panel, index);
            int previousSelectedIndex = Accordion.this.selectedIndex;
            if (Accordion.this.selectedIndex >= index) {
                Accordion.this.selectedIndex++;
            }
            Accordion.this.accordionListeners.panelInserted(Accordion.this, index);
            if (Accordion.this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
                Accordion.this.accordionSelectionListeners.selectedIndexChanged(Accordion.this, Accordion.this.selectedIndex);
            }
        }

        public Component update(int index, Component panel) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component panel) {
            int index = this.indexOf(panel);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Component> remove(int index, int count) {
            Sequence removed = Accordion.this.panels.remove(index, count);
            int previousSelectedIndex = Accordion.this.selectedIndex;
            if (Accordion.this.selectedIndex >= index) {
                if (Accordion.this.selectedIndex < index + count) {
                    Accordion.this.selectedIndex = -1;
                } else {
                    Accordion.this.selectedIndex -= count;
                }
            }
            Accordion.this.accordionListeners.panelsRemoved(Accordion.this, index, (Sequence<Component>)removed);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Component panel = (Component)removed.get(i);
                Accordion.this.remove(panel);
            }
            if (Accordion.this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
                Accordion.this.accordionSelectionListeners.selectedIndexChanged(Accordion.this, Accordion.this.selectedIndex);
            }
            return removed;
        }

        public Component get(int index) {
            return (Component)Accordion.this.panels.get(index);
        }

        public int indexOf(Component panel) {
            return Accordion.this.panels.indexOf((Object)panel);
        }

        public int getLength() {
            return Accordion.this.panels.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)Accordion.this.panels.iterator());
        }
    }
}

