/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.joda.time.Duration;

public class SegmentIntervalUtils {
    private SegmentIntervalUtils() {
    }

    public static boolean eligibleForMissingSegmentCheck(int numSegments, SegmentsValidationAndRetentionConfig validationConfig) {
        return numSegments >= 2 && StringUtils.isNotEmpty((CharSequence)validationConfig.getTimeColumnName());
    }

    public static boolean eligibleForSegmentIntervalCheck(SegmentsValidationAndRetentionConfig validationConfig) {
        return StringUtils.isNotEmpty((CharSequence)validationConfig.getTimeColumnName());
    }

    public static Duration convertToDuration(String pushFrequency) {
        if ("hourly".equalsIgnoreCase(pushFrequency)) {
            return Duration.standardHours((long)1L);
        }
        if ("daily".equalsIgnoreCase(pushFrequency)) {
            return Duration.standardDays((long)1L);
        }
        if ("weekly".equalsIgnoreCase(pushFrequency)) {
            return Duration.standardDays((long)7L);
        }
        if ("monthly".equalsIgnoreCase(pushFrequency)) {
            return Duration.standardDays((long)30L);
        }
        return Duration.standardDays((long)1L);
    }
}

