/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.realtime.provisioning.MemoryEstimator;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.io.configs.SegmentSizeRecommendations;
import org.apache.pinot.controller.recommender.rules.io.params.SegmentSizeRuleParams;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableConfigBuilder;

public class SegmentSizeRule
extends AbstractRule {
    static final int MEGA_BYTE = 0x100000;

    public SegmentSizeRule(InputManager input, ConfigManager output) {
        super(input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InvalidInputException {
        int numRows;
        long segmentSize;
        if (this._input.getTableType().equalsIgnoreCase("REALTIME")) {
            this._output.setSegmentSizeRecommendations(new SegmentSizeRecommendations("Segment sizing for realtime-only tables is done via Realtime Provisioning Rule"));
            return;
        }
        SegmentSizeRuleParams segmentSizeRuleParams = this._input.getSegmentSizeRuleParams();
        if (segmentSizeRuleParams.getActualSegmentSizeMB() == -1 && segmentSizeRuleParams.getNumRowsInActualSegment() == -1) {
            File workingDir = Files.createTempDir();
            try {
                TableConfig tableConfig = this.createTableConfig(this._input.getSchema());
                int numRowsInGeneratedSegment = segmentSizeRuleParams.getNumRowsInGeneratedSegment();
                File generatedSegmentDir = new MemoryEstimator.SegmentGenerator(this._input._schemaWithMetaData, this._input._schema, tableConfig, numRowsInGeneratedSegment, true, workingDir).generate();
                segmentSize = Math.round((double)FileUtils.sizeOfDirectory((File)generatedSegmentDir) * 1.2);
                numRows = numRowsInGeneratedSegment;
            }
            finally {
                FileUtils.deleteQuietly((File)workingDir);
            }
        } else {
            segmentSize = segmentSizeRuleParams.getActualSegmentSizeMB() * 0x100000;
            numRows = segmentSizeRuleParams.getNumRowsInActualSegment();
        }
        SegmentSizeRecommendations params = this.estimate(segmentSize, segmentSizeRuleParams.getDesiredSegmentSizeMB() * 0x100000, numRows, this._input.getNumRecordsPerPush());
        this._output.setSegmentSizeRecommendations(params);
        this._input.capCardinalities((int)params.getNumRowsPerSegment());
    }

    @VisibleForTesting
    SegmentSizeRecommendations estimate(long generatedSegmentSize, int desiredSegmentSize, int numRecordsOfGeneratedSegment, long numRecordsPerPush) {
        double sizeRatio = (double)desiredSegmentSize / (double)generatedSegmentSize;
        long numRowsInDesiredSegment = Math.round((double)numRecordsOfGeneratedSegment * sizeRatio);
        long optimalNumSegments = Math.round((double)numRecordsPerPush / (double)numRowsInDesiredSegment);
        optimalNumSegments = Math.max(optimalNumSegments, 1L);
        long optimalNumRowsInSegment = Math.round((double)numRecordsPerPush / (double)optimalNumSegments);
        double rowRatio = (double)optimalNumRowsInSegment / (double)numRecordsOfGeneratedSegment;
        long optimalSegmentSize = Math.round((double)generatedSegmentSize * rowRatio);
        return new SegmentSizeRecommendations(optimalNumRowsInSegment, optimalNumSegments, optimalSegmentSize);
    }

    private TableConfig createTableConfig(Schema schema) {
        return new TableConfigBuilder(TableType.OFFLINE).setTableName(schema.getSchemaName()).setNoDictionaryColumns(schema.getMetricNames()).build();
    }

    @Override
    public void hideOutput() {
        this._output.setSegmentSizeRecommendations(null);
    }
}

