/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.model.builder.FullAutoModeISBuilder;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.helix.core.PinotHelixBrokerResourceOnlineOfflineStateModelGenerator;
import org.apache.pinot.controller.helix.core.PinotHelixSegmentOnlineOfflineStateModelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixSetupUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixSetupUtils.class);

    private HelixSetupUtils() {
    }

    public static HelixManager setupHelixController(String helixClusterName, String zkPath, String instanceId) {
        HelixSetupUtils.setupHelixClusterIfNeeded(helixClusterName, zkPath);
        return HelixControllerMain.startHelixController((String)zkPath, (String)helixClusterName, (String)instanceId, (String)"STANDALONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupHelixClusterIfNeeded(String helixClusterName, String zkPath) {
        try (ZKHelixAdmin admin = null;){
            admin = ((ZKHelixAdmin.Builder)new ZKHelixAdmin.Builder().setZkAddress(zkPath)).build();
            if (admin.getClusters().contains(helixClusterName)) {
                LOGGER.info("Helix cluster: {} already exists", (Object)helixClusterName);
            } else {
                LOGGER.info("Creating a new Helix cluster: {}", (Object)helixClusterName);
                admin.addCluster(helixClusterName, false);
                HelixConfigScope configScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(helixClusterName).build();
                HashMap<String, String> configMap = new HashMap<String, String>();
                configMap.put("allowParticipantAutoJoin", Boolean.toString(true));
                configMap.put("enable.case.insensitive", Boolean.toString(true));
                configMap.put("default.hyperloglog.log2m", Integer.toString(8));
                configMap.put("pinot.broker.enable.query.limit.override", Boolean.toString(false));
                admin.setConfig(configScope, configMap);
                LOGGER.info("New Helix cluster: {} created", (Object)helixClusterName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupPinotCluster(String helixClusterName, String zkPath, boolean isUpdateStateModel, boolean enableBatchMessageMode, ControllerConf controllerConf) {
        ZkClient zkClient = null;
        int zkClientSessionConfig = controllerConf.getProperty("zk.client.session.timeout.ms", 30000);
        int zkClientConnectionTimeoutMs = controllerConf.getProperty("zk.client.connection.timeout.ms", 60000);
        try {
            zkClient = new ZkClient.Builder().setZkServer(zkPath).setSessionTimeout(Integer.valueOf(zkClientSessionConfig)).setConnectionTimeout(Integer.valueOf(zkClientConnectionTimeoutMs)).setZkSerializer((ZkSerializer)new ZNRecordSerializer()).build();
            zkClient.waitUntilConnected((long)zkClientConnectionTimeoutMs, TimeUnit.MILLISECONDS);
            ZKHelixAdmin helixAdmin = new ZKHelixAdmin((RealmAwareZkClient)zkClient);
            ZKHelixDataAccessor helixDataAccessor = new ZKHelixDataAccessor(helixClusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
            ConfigAccessor configAccessor = new ConfigAccessor((RealmAwareZkClient)zkClient);
            Preconditions.checkState((boolean)helixAdmin.getClusters().contains(helixClusterName), (Object)String.format("Helix cluster: %s hasn't been set up", helixClusterName));
            HelixSetupUtils.addSegmentStateModelDefinitionIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, (HelixDataAccessor)helixDataAccessor, isUpdateStateModel);
            HelixSetupUtils.createBrokerResourceIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, enableBatchMessageMode);
            HelixSetupUtils.createLeadControllerResourceIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, configAccessor, enableBatchMessageMode, controllerConf.getLeadControllerResourceRebalanceStrategy());
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    private static void addSegmentStateModelDefinitionIfNeeded(String helixClusterName, HelixAdmin helixAdmin, HelixDataAccessor helixDataAccessor, boolean isUpdateStateModel) {
        String segmentStateModelName = "SegmentOnlineOfflineStateModel";
        StateModelDefinition stateModelDefinition = helixAdmin.getStateModelDef(helixClusterName, segmentStateModelName);
        if (stateModelDefinition == null || isUpdateStateModel) {
            if (stateModelDefinition == null) {
                LOGGER.info("Adding state model: {} with CONSUMING state", (Object)segmentStateModelName);
            } else {
                LOGGER.info("Updating state model: {} to contain CONSUMING state", (Object)segmentStateModelName);
            }
            helixDataAccessor.createStateModelDef(PinotHelixSegmentOnlineOfflineStateModelGenerator.generatePinotStateModelDefinition());
        }
    }

    private static void createBrokerResourceIfNeeded(String helixClusterName, HelixAdmin helixAdmin, boolean enableBatchMessageMode) {
        String stateModel = "BrokerResourceOnlineOfflineStateModel";
        StateModelDefinition stateModelDef = helixAdmin.getStateModelDef(helixClusterName, stateModel);
        if (stateModelDef == null) {
            LOGGER.info("Adding state model: {}", (Object)stateModel);
            helixAdmin.addStateModelDef(helixClusterName, stateModel, PinotHelixBrokerResourceOnlineOfflineStateModelGenerator.generatePinotStateModelDefinition());
        }
        if (helixAdmin.getResourceIdealState(helixClusterName, "brokerResource") == null) {
            LOGGER.info("Adding resource: {}", (Object)"brokerResource");
            IdealState idealState = new CustomModeISBuilder("brokerResource").setStateModel(stateModel).build();
            idealState.setBatchMessageMode(enableBatchMessageMode);
            helixAdmin.addResource(helixClusterName, "brokerResource", idealState);
        }
    }

    private static void createLeadControllerResourceIfNeeded(String helixClusterName, HelixAdmin helixAdmin, ConfigAccessor configAccessor, boolean enableBatchMessageMode, String leadControllerResourceRebalanceStrategy) {
        IdealState idealState = helixAdmin.getResourceIdealState(helixClusterName, "leadControllerResource");
        if (idealState == null) {
            LOGGER.info("Adding resource: {}", (Object)"leadControllerResource");
            FullAutoModeISBuilder idealStateBuilder = new FullAutoModeISBuilder("leadControllerResource");
            idealStateBuilder.setStateModel("MasterSlave").setRebalanceStrategy(leadControllerResourceRebalanceStrategy);
            idealStateBuilder.setNumPartitions(24);
            for (int i = 0; i < 24; ++i) {
                idealStateBuilder.add(LeadControllerUtils.generatePartitionName((int)i));
            }
            idealStateBuilder.setNumReplica(1);
            idealStateBuilder.setMinActiveReplica(0);
            idealStateBuilder.setRebalanceDelay(300000);
            idealStateBuilder.enableDelayRebalance();
            idealState = idealStateBuilder.build();
            idealState.setInstanceGroupTag("controller");
            idealState.setBatchMessageMode(enableBatchMessageMode);
            helixAdmin.addResource(helixClusterName, "leadControllerResource", idealState);
        } else if (!idealState.isEnabled()) {
            idealState.enable(true);
            helixAdmin.updateIdealState(helixClusterName, "leadControllerResource", idealState);
        }
        ResourceConfig resourceConfig = configAccessor.getResourceConfig(helixClusterName, "leadControllerResource");
        if (resourceConfig == null) {
            resourceConfig = new ResourceConfig("leadControllerResource");
        }
        resourceConfig.putSimpleConfig("RESOURCE_ENABLED", Boolean.TRUE.toString());
        configAccessor.setResourceConfig(helixClusterName, "leadControllerResource", resourceConfig);
    }
}

