/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance.tenant;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TenantRebalanceResult {
    private String _jobId;
    private Map<String, RebalanceResult> _rebalanceTableResults;

    public TenantRebalanceResult(String jobId, Map<String, RebalanceResult> rebalanceTableResults, boolean verbose) {
        this._jobId = jobId;
        if (verbose) {
            this._rebalanceTableResults = rebalanceTableResults;
        } else {
            this._rebalanceTableResults = new HashMap<String, RebalanceResult>();
            rebalanceTableResults.forEach((table, result) -> this._rebalanceTableResults.put((String)table, new RebalanceResult(result.getJobId(), result.getStatus(), result.getDescription(), null, null, null)));
        }
    }

    public String getJobId() {
        return this._jobId;
    }

    public Map<String, RebalanceResult> getRebalanceTableResults() {
        return this._rebalanceTableResults;
    }

    public void setJobId(String jobId) {
        this._jobId = jobId;
    }

    public void setRebalanceTableResults(Map<String, RebalanceResult> rebalanceTableResults) {
        this._rebalanceTableResults = rebalanceTableResults;
    }
}

