/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.core.minion.PinotTaskConfig;

public class TaskGeneratorUtils {
    private static final EnumSet<TaskState> TASK_FINAL_STATES = EnumSet.of(TaskState.COMPLETED, TaskState.FAILED, TaskState.ABORTED, TaskState.TIMED_OUT);

    private TaskGeneratorUtils() {
    }

    public static Set<Segment> getRunningSegments(String taskType, ClusterInfoAccessor clusterInfoAccessor) {
        HashSet<Segment> runningSegments = new HashSet<Segment>();
        Map<String, TaskState> taskStates = clusterInfoAccessor.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            if (TASK_FINAL_STATES.contains(entry.getValue())) continue;
            String taskName = entry.getKey();
            for (PinotTaskConfig pinotTaskConfig : clusterInfoAccessor.getTaskConfigs(taskName)) {
                Map configs = pinotTaskConfig.getConfigs();
                runningSegments.add(new Segment((String)configs.get("tableName"), (String)configs.get("segmentName")));
            }
        }
        return runningSegments;
    }

    public static Map<String, TaskState> getIncompleteTasks(String taskType, String tableNameWithType, ClusterInfoAccessor clusterInfoAccessor) {
        HashMap<String, TaskState> incompleteTasks = new HashMap<String, TaskState>();
        Map<String, TaskState> taskStates = clusterInfoAccessor.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            if (TASK_FINAL_STATES.contains(entry.getValue())) continue;
            String taskName = entry.getKey();
            for (PinotTaskConfig pinotTaskConfig : clusterInfoAccessor.getTaskConfigs(taskName)) {
                if (!tableNameWithType.equals(pinotTaskConfig.getConfigs().get("tableName"))) continue;
                incompleteTasks.put(taskName, entry.getValue());
            }
        }
        return incompleteTasks;
    }

    public static void forRunningTasks(String tableNameWithType, String taskType, ClusterInfoAccessor clusterInfoAccessor, Consumer<Map<String, String>> taskConfigConsumer) {
        Map<String, TaskState> taskStates = clusterInfoAccessor.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            if (TASK_FINAL_STATES.contains(entry.getValue())) continue;
            String taskName = entry.getKey();
            for (PinotTaskConfig pinotTaskConfig : clusterInfoAccessor.getTaskConfigs(taskName)) {
                Map config = pinotTaskConfig.getConfigs();
                String tableNameFromTaskConfig = (String)config.get("tableName");
                if (!tableNameWithType.equals(tableNameFromTaskConfig)) continue;
                taskConfigConsumer.accept(config);
            }
        }
    }
}

