/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTaskSchedulerUpdater
implements IZkDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableTaskSchedulerUpdater.class);
    private final String _tableWithType;
    private final PinotTaskManager _pinotTaskManager;

    public TableTaskSchedulerUpdater(String tableWithType, PinotTaskManager pinotTaskManager) {
        this._tableWithType = tableWithType;
        this._pinotTaskManager = pinotTaskManager;
    }

    public void handleDataChange(String dataPath, Object data) throws Exception {
        try {
            this._pinotTaskManager.updateCronTaskScheduler(this._tableWithType);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update cron task scheduler for table {}", (Object)this._tableWithType, (Object)e);
            throw e;
        }
    }

    public void handleDataDeleted(String dataPath) throws Exception {
        try {
            this._pinotTaskManager.cleanUpCronTaskSchedulerForTable(this._tableWithType);
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete cron task scheduler for table {}", (Object)this._tableWithType, (Object)e);
            throw e;
        }
    }
}

