/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment.strategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.AllServersSegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.BalancedNumSegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.ReplicaGroupSegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.SegmentAssignmentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentAssignmentStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentAssignmentStrategyFactory.class);

    private SegmentAssignmentStrategyFactory() {
    }

    public static SegmentAssignmentStrategy getSegmentAssignmentStrategy(HelixManager helixManager, TableConfig tableConfig, String assignmentType, InstancePartitions instancePartitions) {
        SegmentAssignmentStrategy segmentAssignmentStrategy;
        SegmentAssignmentConfig segmentAssignmentConfig;
        String assignmentStrategy = null;
        TableType currentTableType = tableConfig.getTableType();
        Map segmentAssignmentConfigMap = tableConfig.getSegmentAssignmentConfigMap();
        if (tableConfig.isDimTable()) {
            Preconditions.checkState((currentTableType == TableType.OFFLINE ? 1 : 0) != 0, (Object)"All Servers Segment assignment Strategy is only applicable to Dim OfflineTables");
            AllServersSegmentAssignmentStrategy segmentAssignmentStrategy2 = new AllServersSegmentAssignmentStrategy();
            segmentAssignmentStrategy2.init(helixManager, tableConfig);
            return segmentAssignmentStrategy2;
        }
        if (segmentAssignmentConfigMap != null && (segmentAssignmentConfig = (SegmentAssignmentConfig)segmentAssignmentConfigMap.get(assignmentType.toUpperCase())) != null) {
            assignmentStrategy = segmentAssignmentConfig.getAssignmentStrategy().toLowerCase();
        }
        if (assignmentStrategy == null) {
            Preconditions.checkState((instancePartitions != null ? 1 : 0) != 0, (Object)"Failed to find instance partitions for segment assignment strategy");
            int numReplicaGroups = instancePartitions.getNumReplicaGroups();
            int numPartitions = instancePartitions.getNumPartitions();
            segmentAssignmentStrategy = numReplicaGroups == 1 && numPartitions == 1 ? new BalancedNumSegmentAssignmentStrategy() : new ReplicaGroupSegmentAssignmentStrategy();
        } else {
            switch (assignmentStrategy) {
                case "replicagroup": {
                    segmentAssignmentStrategy = new ReplicaGroupSegmentAssignmentStrategy();
                    break;
                }
                default: {
                    segmentAssignmentStrategy = new BalancedNumSegmentAssignmentStrategy();
                }
            }
        }
        segmentAssignmentStrategy.init(helixManager, tableConfig);
        return segmentAssignmentStrategy;
    }
}

