/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategyFactory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSegmentAssignment
implements SegmentAssignment {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    protected HelixManager _helixManager;
    protected String _tableNameWithType;
    protected int _replication;
    protected String _partitionColumn;
    protected TableConfig _tableConfig;

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        this._helixManager = helixManager;
        this._tableNameWithType = tableConfig.getTableName();
        this._tableConfig = tableConfig;
        this._replication = tableConfig.getReplication();
        this._partitionColumn = TableConfigUtils.getPartitionColumn((TableConfig)this._tableConfig);
        if (this._partitionColumn == null) {
            this._logger.info("Initialized with replication: {} without partition column for table: {} ", (Object)this._replication, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Initialized with replication: {} and partition column: {} for table: {}", new Object[]{this._replication, this._partitionColumn, this._tableNameWithType});
        }
    }

    protected Pair<List<Map<String, Map<String, String>>>, Map<String, Map<String, String>>> rebalanceTiers(Map<String, Map<String, String>> currentAssignment, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, boolean bootstrap, InstancePartitionsType instancePartitionsType) {
        if (sortedTiers == null) {
            return Pair.of(null, currentAssignment);
        }
        Preconditions.checkState((tierInstancePartitionsMap != null ? 1 : 0) != 0, (Object)"Tier to instancePartitions map is null");
        this._logger.info("Rebalancing tiers: {} for table: {} with bootstrap: {}", new Object[]{tierInstancePartitionsMap.keySet(), this._tableNameWithType, bootstrap});
        SegmentAssignmentUtils.TierSegmentAssignment tierSegmentAssignment = new SegmentAssignmentUtils.TierSegmentAssignment(this._tableNameWithType, sortedTiers, currentAssignment);
        Map<String, Map<String, Map<String, String>>> tierNameToSegmentAssignmentMap = tierSegmentAssignment.getTierNameToSegmentAssignmentMap();
        ArrayList<Map<String, Map<String, String>>> newTierAssignments = new ArrayList<Map<String, Map<String, String>>>(tierNameToSegmentAssignmentMap.size());
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : tierNameToSegmentAssignmentMap.entrySet()) {
            String tierName = entry.getKey();
            Map<String, Map<String, String>> tierCurrentAssignment = entry.getValue();
            InstancePartitions tierInstancePartitions = tierInstancePartitionsMap.get(tierName);
            Preconditions.checkNotNull((Object)tierInstancePartitions, (String)"Failed to find instance partitions for tier: %s of table: %s", (Object)tierName, (Object)this._tableNameWithType);
            SegmentAssignmentStrategy segmentAssignmentStrategy = SegmentAssignmentStrategyFactory.getSegmentAssignmentStrategy(this._helixManager, this._tableConfig, tierName, tierInstancePartitions);
            this._logger.info("Rebalancing tier: {} for table: {} with bootstrap: {}, instance partitions: {}", new Object[]{tierName, this._tableNameWithType, bootstrap, tierInstancePartitions});
            newTierAssignments.add(this.reassignSegments(tierName, tierCurrentAssignment, tierInstancePartitions, bootstrap, segmentAssignmentStrategy, instancePartitionsType));
        }
        return Pair.of(newTierAssignments, tierSegmentAssignment.getNonTierSegmentAssignment());
    }

    protected Map<String, Map<String, String>> reassignSegments(String instancePartitionType, Map<String, Map<String, String>> currentAssignment, InstancePartitions instancePartitions, boolean bootstrap, SegmentAssignmentStrategy segmentAssignmentStrategy, InstancePartitionsType instancePartitionsType) {
        Map<String, Map<String, String>> newAssignment;
        if (bootstrap) {
            this._logger.info("Bootstrapping segment assignment for {} segments of table: {}", (Object)instancePartitionType, (Object)this._tableNameWithType);
            newAssignment = new TreeMap<String, Map<String, String>>();
            for (String segment : currentAssignment.keySet()) {
                List<String> assignedInstances = segmentAssignmentStrategy.assignSegment(segment, newAssignment, instancePartitions, instancePartitionsType);
                newAssignment.put(segment, SegmentAssignmentUtils.getInstanceStateMap(assignedInstances, "ONLINE"));
            }
        } else {
            newAssignment = segmentAssignmentStrategy.reassignSegments(currentAssignment, instancePartitions, instancePartitionsType);
        }
        return newAssignment;
    }
}

