/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class PinotHelixSegmentOnlineOfflineStateModelGenerator {
    public static final String PINOT_SEGMENT_ONLINE_OFFLINE_STATE_MODEL = "SegmentOnlineOfflineStateModel";
    public static final String ONLINE_STATE = "ONLINE";
    public static final String OFFLINE_STATE = "OFFLINE";
    public static final String DROPPED_STATE = "DROPPED";
    public static final String CONSUMING_STATE = "CONSUMING";

    private PinotHelixSegmentOnlineOfflineStateModelGenerator() {
    }

    public static StateModelDefinition generatePinotStateModelDefinition() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(PINOT_SEGMENT_ONLINE_OFFLINE_STATE_MODEL);
        builder.initialState(OFFLINE_STATE);
        builder.addState(ONLINE_STATE);
        builder.addState(CONSUMING_STATE);
        builder.addState(OFFLINE_STATE);
        builder.addState(DROPPED_STATE);
        builder.addTransition(CONSUMING_STATE, ONLINE_STATE);
        builder.addTransition(OFFLINE_STATE, CONSUMING_STATE);
        builder.addTransition(OFFLINE_STATE, ONLINE_STATE);
        builder.addTransition(CONSUMING_STATE, OFFLINE_STATE);
        builder.addTransition(ONLINE_STATE, OFFLINE_STATE);
        builder.addTransition(OFFLINE_STATE, DROPPED_STATE);
        builder.dynamicUpperBound(ONLINE_STATE, "R");
        builder.dynamicUpperBound(CONSUMING_STATE, "R");
        StateModelDefinition statemodelDefinition = builder.build();
        return statemodelDefinition;
    }

    public static StateModelDefinition generatePinotStateModelDefinitionOld() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord(PINOT_SEGMENT_ONLINE_OFFLINE_STATE_MODEL);
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), OFFLINE_STATE);
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add(ONLINE_STATE);
        statePriorityList.add(OFFLINE_STATE);
        statePriorityList.add(DROPPED_STATE);
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals(ONLINE_STATE)) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
            }
            if (state.equals(OFFLINE_STATE)) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals(DROPPED_STATE)) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals(ONLINE_STATE)) {
                metadata = new HashMap();
                metadata.put(OFFLINE_STATE, OFFLINE_STATE);
                metadata.put(DROPPED_STATE, DROPPED_STATE);
                record.setMapField(key, metadata);
            }
            if (!state.equals(OFFLINE_STATE)) continue;
            metadata = new HashMap();
            metadata.put(ONLINE_STATE, ONLINE_STATE);
            metadata.put(DROPPED_STATE, DROPPED_STATE);
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("ONLINE-OFFLINE");
        stateTransitionPriorityList.add("ONLINE-DROPPED");
        stateTransitionPriorityList.add("OFFLINE-ONLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        throw new RuntimeException("This state model should not be used");
    }
}

