/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.introspect.CodehausJacksonIntrospector;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Zookeeper"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class ZookeeperResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperResource.class);
    @VisibleForTesting
    static final ObjectMapper MAPPER = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new CodehausJacksonIntrospector());
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Path(value="/zk/get")
    @Authorize(targetType=TargetType.CLUSTER, action="GetZnode")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get content of the znode")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public String getData(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        ZNRecord znRecord = this._pinotHelixResourceManager.readZKData(path = this.validateAndNormalizeZKPath(path, true));
        if (znRecord != null) {
            try {
                return MAPPER.writeValueAsString((Object)znRecord);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @DELETE
    @Path(value="/zk/delete")
    @Authorize(targetType=TargetType.CLUSTER, action="DeleteZnode")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the znode at this path")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse delete(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        boolean success = this._pinotHelixResourceManager.deleteZKPath(path = this.validateAndNormalizeZKPath(path, true));
        if (success) {
            return new SuccessResponse("Successfully deleted path: " + path);
        }
        throw new ControllerApplicationException(LOGGER, "Failed to delete path: " + path, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @PUT
    @Path(value="/zk/putChildren")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateZnode")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the content of multiple znRecord node under the same path")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse putChildren(@ApiParam(value="Zookeeper path of parent, must start with /", required=true) @QueryParam(value="path") String path, @ApiParam(value="Content") @QueryParam(value="data") @Nullable String data, @ApiParam(value="expectedVersion", defaultValue="-1") @QueryParam(value="expectedVersion") @DefaultValue(value="-1") int expectedVersion, @ApiParam(value="accessOption", defaultValue="1") @QueryParam(value="accessOption") @DefaultValue(value="1") int accessOption, @Nullable String payload) {
        List znRecords;
        path = this.validateAndNormalizeZKPath(path, false);
        if (StringUtils.isEmpty((String)data)) {
            data = payload;
        }
        if (StringUtils.isEmpty((String)data)) {
            throw new ControllerApplicationException(LOGGER, "Must provide data through query parameter or payload", Response.Status.BAD_REQUEST);
        }
        try {
            znRecords = (List)MAPPER.readValue(data, (TypeReference)new TypeReference<List<ZNRecord>>(){});
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to deserialize the data", Response.Status.BAD_REQUEST, (Throwable)e);
        }
        for (ZNRecord znRecord : znRecords) {
            String childPath = path + "/" + znRecord.getId();
            try {
                boolean result = this._pinotHelixResourceManager.setZKData(childPath, znRecord, expectedVersion, accessOption);
                if (result) continue;
                throw new ControllerApplicationException(LOGGER, "Failed to update path: " + childPath, Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                throw new ControllerApplicationException(LOGGER, "Failed to update path: " + childPath, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        return new SuccessResponse("Successfully updated " + znRecords.size() + " ZnRecords under path: " + path);
    }

    @PUT
    @Path(value="/zk/put")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateZnode")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the content of the node")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse putData(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path, @ApiParam(value="Content") @QueryParam(value="data") @Nullable String data, @ApiParam(value="expectedVersion", defaultValue="-1") @QueryParam(value="expectedVersion") @DefaultValue(value="-1") int expectedVersion, @ApiParam(value="accessOption", defaultValue="1") @QueryParam(value="accessOption") @DefaultValue(value="1") int accessOption, @Nullable String payload) {
        ZNRecord znRecord;
        path = this.validateAndNormalizeZKPath(path, false);
        if (StringUtils.isEmpty((String)data)) {
            data = payload;
        }
        if (StringUtils.isEmpty((String)data)) {
            throw new ControllerApplicationException(LOGGER, "Must provide data through query parameter or payload", Response.Status.BAD_REQUEST);
        }
        try {
            znRecord = (ZNRecord)MAPPER.readValue(data, ZNRecord.class);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to deserialize the data", Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            boolean result = this._pinotHelixResourceManager.setZKData(path, znRecord, expectedVersion, accessOption);
            if (result) {
                return new SuccessResponse("Successfully updated path: " + path);
            }
            throw new ControllerApplicationException(LOGGER, "Failed to update path: " + path, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update path: " + path, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="/zk/ls")
    @Authorize(targetType=TargetType.CLUSTER, action="GetZnode")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the child znodes")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=500, message="Internal server error")})
    public String ls(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        path = this.validateAndNormalizeZKPath(path, true);
        List<String> childNames = this._pinotHelixResourceManager.getZKChildNames(path);
        try {
            return JsonUtils.objectToString(childNames);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/zk/getChildren")
    @Authorize(targetType=TargetType.CLUSTER, action="GetZnode")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all child znodes")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=500, message="Internal server error")})
    public String getChildren(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        List<ZNRecord> znRecords = this._pinotHelixResourceManager.getZKChildren(path = this.validateAndNormalizeZKPath(path, true));
        if (znRecords != null) {
            ArrayList<ZNRecord> nonNullRecords = new ArrayList<ZNRecord>(znRecords.size());
            for (ZNRecord znRecord : znRecords) {
                if (znRecord == null) continue;
                nonNullRecords.add(znRecord);
            }
            try {
                return MAPPER.writeValueAsString(nonNullRecords);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new ControllerApplicationException(LOGGER, String.format("ZNRecord children %s not found", path), Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="/zk/lsl")
    @Authorize(targetType=TargetType.CLUSTER, action="GetZnode")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the child znodes along with Stats")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="ZK Path not found"), @ApiResponse(code=500, message="Internal server error")})
    public String lsl(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        path = this.validateAndNormalizeZKPath(path, true);
        Map<String, Stat> childrenStats = this._pinotHelixResourceManager.getZKChildrenStats(path);
        try {
            return JsonUtils.objectToString(childrenStats);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/zk/stat")
    @Authorize(targetType=TargetType.CLUSTER, action="GetZnode")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the stat", notes=" Use this api to fetch additional details of a znode such as creation time, modified time, numChildren etc ")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public String stat(@ApiParam(value="Zookeeper Path, must start with /", required=true) @QueryParam(value="path") String path) {
        path = this.validateAndNormalizeZKPath(path, true);
        Stat stat = this._pinotHelixResourceManager.getZKStat(path);
        try {
            return JsonUtils.objectToString((Object)stat);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String validateAndNormalizeZKPath(String path, boolean shouldExist) {
        if (path == null) {
            throw new ControllerApplicationException(LOGGER, "ZKPath cannot be null", Response.Status.BAD_REQUEST);
        }
        if (!(path = path.trim()).startsWith("/")) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " must start with /", Response.Status.BAD_REQUEST);
        }
        if (!path.equals("/") && path.endsWith("/")) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " cannot end with /", Response.Status.BAD_REQUEST);
        }
        if (shouldExist && this._pinotHelixResourceManager.getZKStat(path) == null) {
            throw new ControllerApplicationException(LOGGER, "ZKPath " + path + " does not exist", Response.Status.NOT_FOUND);
        }
        return path;
    }

    static {
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        MAPPER.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        MAPPER.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
        MAPPER.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

