/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.common.restlet.resources.TableSizeInfo;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTableSizeReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerTableSizeReader.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;

    public ServerTableSizeReader(Executor executor, HttpClientConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public Map<String, List<SegmentSizeInfo>> getSegmentSizeInfoFromServers(BiMap<String, String> serverEndPoints, String tableNameWithType, int timeoutMs) {
        int numServers = serverEndPoints.size();
        LOGGER.info("Reading segment sizes from {} servers for table: {} with timeout: {}ms", new Object[]{numServers, tableNameWithType, timeoutMs});
        ArrayList<String> serverUrls = new ArrayList<String>(numServers);
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String tableSizeUri = endpoint + "/table/" + tableNameWithType + "/size";
            serverUrls.add(tableSizeUri);
        }
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, tableNameWithType, false, timeoutMs, "get segment size info from servers");
        HashMap<String, List<SegmentSizeInfo>> serverToSegmentSizeInfoListMap = new HashMap<String, List<SegmentSizeInfo>>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                TableSizeInfo tableSizeInfo = (TableSizeInfo)JsonUtils.stringToObject((String)streamResponse.getValue(), TableSizeInfo.class);
                serverToSegmentSizeInfoListMap.put(streamResponse.getKey(), tableSizeInfo.getSegments());
            }
            catch (IOException e) {
                ++failedParses;
                LOGGER.error("Unable to parse server {} response due to an error: ", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.warn("Failed to parse {} / {} segment size info responses from servers.", (Object)failedParses, (Object)serverUrls.size());
        }
        return serverToSegmentSizeInfoListMap;
    }
}

