/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.controllerjob.ControllerJobType;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.api.resources.ServerReloadControllerJobStatusResponse;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.controller.util.TableMetadataReader;
import org.apache.pinot.controller.util.TableTierReader;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Segment"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotSegmentRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentRestletResource.class);
    @Inject
    ControllerConf _controllerConf;
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    Executor _executor;
    @Inject
    HttpClientConnectionManager _connectionManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSegment")
    @ApiOperation(value="List all segments. An optional 'excludeReplacedSegments' parameter is used to get the list of segments which has not yet been replaced (determined by segment lineage entries) and can be queried from the table. The value is false by default.", notes="List all segments")
    public List<Map<TableType, List<String>>> getSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to exclude replaced segments in the response, which have been replaced specified in the segment lineage entries and cannot be queried from the table") @QueryParam(value="excludeReplacedSegments") String excludeReplacedSegments, @ApiParam(value="Start timestamp (inclusive)") @QueryParam(value="startTimestamp") @DefaultValue(value="") String startTimestampStr, @ApiParam(value="End timestamp (exclusive)") @QueryParam(value="endTimestamp") @DefaultValue(value="") String endTimestampStr, @ApiParam(value="Whether to exclude the segments overlapping with the timestamps, false by default") @QueryParam(value="excludeOverlapping") @DefaultValue(value="false") boolean excludeOverlapping) {
        boolean shouldExcludeReplacedSegments = Boolean.parseBoolean(excludeReplacedSegments);
        return this.selectSegments(tableName, tableTypeStr, shouldExcludeReplacedSegments, startTimestampStr, endTimestampStr, excludeOverlapping).stream().map(pair -> Collections.singletonMap((TableType)pair.getKey(), (List)pair.getValue())).collect(Collectors.toList());
    }

    @GET
    @Path(value="segments/{tableName}/servers")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetServerMap")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server", notes="Get a map from server to segments hosted by the server")
    public List<Map<String, Object>> getServerToSegmentsMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("serverToSegmentsMap", this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @GET
    @Path(value="segments/{tableName}/lineage")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSegmentLineage")
    @Authenticate(value=AccessType.READ)
    @Produces(value={"application/json"})
    @ApiOperation(value="List segment lineage", notes="List segment lineage in chronologically sorted order")
    public Response listSegmentLineage(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type should either be offline or realtime", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            Response.ResponseBuilder builder = Response.ok();
            SegmentLineage segmentLineage = this._pinotHelixResourceManager.listSegmentLineage(tableNameWithType);
            if (segmentLineage != null) {
                builder.entity((Object)segmentLineage.toJsonObject());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Exception while listing segment lineage: %s for table: %s.", e.getMessage(), tableNameWithType), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetServerMap")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, String> resultForTable = new LinkedHashMap<String, String>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("segments", JsonUtils.objectToString(this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType)));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/metadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetServerMap")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        return this.getServerToSegmentsMapDeprecated1(tableName, stateStr, tableTypeStr);
    }

    @GET
    @Path(value="segments/{tableName}/crc")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSegmentMap")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (only apply to OFFLINE table)", notes="Get a map from segment to CRC of the segment (only apply to OFFLINE table)")
    public Map<String, String> getSegmentToCrcMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        String offlineTableName = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, TableType.OFFLINE, LOGGER).get(0);
        return this._pinotHelixResourceManager.getSegmentsCrcForTable(offlineTableName);
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/crc")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSegmentMap")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)", notes="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)")
    public Map<String, String> getSegmentToCrcMapDeprecated(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        return this.getSegmentToCrcMap(tableName);
    }

    @GET
    @Path(value="segments/{tableName}/{segmentName}/metadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment", notes="Get the metadata for a segment")
    public Map<String, Object> getSegmentMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Columns name", allowMultiple=true) @QueryParam(value="columns") List<String> columns) {
        segmentName = URIUtils.decode((String)segmentName);
        Map<String, String> segmentMetadata = null;
        if (TableNameBuilder.getTableTypeFromTableName((String)tableName) != null) {
            segmentMetadata = this.getSegmentMetadataInternal(tableName, segmentName);
        } else {
            segmentMetadata = this.getSegmentMetadataInternal(TableNameBuilder.OFFLINE.tableNameWithType(tableName), segmentName);
            if (segmentMetadata == null) {
                segmentMetadata = this.getSegmentMetadataInternal(TableNameBuilder.REALTIME.tableNameWithType(tableName), segmentName);
            }
        }
        if (segmentMetadata != null) {
            HashMap<String, Object> result = new HashMap<String, Object>(segmentMetadata);
            if (columns.size() > 0) {
                JsonNode segmentsMetadataJson = this.getExtraMetaData(tableName, segmentName, columns);
                if (segmentsMetadataJson.has("indexes")) {
                    result.put("indexes", segmentsMetadataJson.get("indexes"));
                }
                if (segmentsMetadataJson.has("columns")) {
                    result.put("columns", segmentsMetadataJson.get("columns"));
                }
            }
            return result;
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    private JsonNode getExtraMetaData(String tableName, String segmentName, List<String> columns) {
        try {
            TableMetadataReader tableMetadataReader = new TableMetadataReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
            return tableMetadataReader.getSegmentMetadata(tableName, segmentName, columns, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IOException ioe) {
            throw new ControllerApplicationException(LOGGER, "Error parsing Pinot server response: " + ioe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ioe);
        }
    }

    @Nullable
    private Map<String, String> getSegmentMetadataInternal(String tableNameWithType, String segmentName) {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata(propertyStore, (String)tableNameWithType, (String)segmentName);
        return segmentZKMetadata != null ? segmentZKMetadata.toMap() : null;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/metadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER);
        ArrayList<List<Map<String, Object>>> resultList = new ArrayList<List<Map<String, Object>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            Map<String, Object> segmentMetadata = this.getSegmentMetadata(tableNameWithType, segmentName, Collections.emptyList());
            if (segmentMetadata == null) continue;
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("state", segmentMetadata);
            resultList.add(Collections.singletonList(resultForTable));
        }
        if (resultList.isEmpty()) {
            String errorMessage = "Failed to find segment: " + segmentName + " in table: " + tableName;
            if (tableType != null) {
                errorMessage = errorMessage + " of type: " + tableType;
            }
            throw new ControllerApplicationException(LOGGER, errorMessage, Response.Status.NOT_FOUND);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        return this.getSegmentMetadataDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @POST
    @Path(value="segments/{tableName}/{segmentName}/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment", notes="Reload a segment")
    public SuccessResponse reloadSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Whether to force server to download segment") @QueryParam(value="forceDownload") @DefaultValue(value="false") boolean forceDownload) {
        segmentName = URIUtils.decode((String)segmentName);
        String tableNameWithType = this.getExistingTable(tableName, segmentName);
        Pair<Integer, String> msgInfo = this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName, forceDownload);
        boolean zkJobMetaWriteSuccess = false;
        if ((Integer)msgInfo.getLeft() > 0) {
            try {
                if (this._pinotHelixResourceManager.addNewReloadSegmentJob(tableNameWithType, segmentName, (String)msgInfo.getRight(), (Integer)msgInfo.getLeft())) {
                    zkJobMetaWriteSuccess = true;
                } else {
                    LOGGER.error("Failed to add reload segment job meta into zookeeper for table: {}, segment: {}", (Object)tableNameWithType, (Object)segmentName);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to add reload segment job meta into zookeeper for table: {}, segment: {}", new Object[]{tableNameWithType, segmentName, e});
            }
            return new SuccessResponse(String.format("Submitted reload job id: %s, sent %d reload messages. Job meta ZK storage status: %s", msgInfo.getRight(), msgInfo.getLeft(), zkJobMetaWriteSuccess ? "SUCCESS" : "FAILED"));
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    private String getExistingTable(String tableName, String segmentName) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType == null) {
            tableType = SegmentName.isRealtimeSegmentName((String)segmentName) ? TableType.REALTIME : TableType.OFFLINE;
        }
        return ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
    }

    @POST
    @Path(value="segments/{tableNameWithType}/{segmentName}/reset")
    @Authorize(targetType=TargetType.CLUSTER, action="ResetSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Resets a segment by first disabling it, waiting for external view to stabilize, and finally enabling it again", notes="Resets a segment by disabling and then enabling it")
    public SuccessResponse resetSegment(@ApiParam(value="Name of the table with type", required=true) @PathParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Name of the target instance to reset") @QueryParam(value="targetInstance") @Nullable String targetInstance) {
        segmentName = URIUtils.decode((String)segmentName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        try {
            Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)"Must provide table name with type: %s", (Object)tableNameWithType);
            this._pinotHelixResourceManager.resetSegment(tableNameWithType, segmentName, targetInstance);
            return new SuccessResponse(String.format("Successfully reset segment: %s of table: %s", segmentName, tableNameWithType));
        }
        catch (IllegalStateException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segment: %s of table: %s. %s", segmentName, tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="segments/{tableNameWithType}/reset")
    @Authorize(targetType=TargetType.CLUSTER, action="ResetSegment")
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Resets all segments (when errorSegmentsOnly = false) or segments with Error state (when errorSegmentsOnly = true) of the table, by first disabling them, waiting for external view to stabilize, and finally enabling them", notes="Resets segments by disabling and then enabling them")
    public SuccessResponse resetSegments(@ApiParam(value="Name of the table with type", required=true) @PathParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Name of the target instance to reset") @QueryParam(value="targetInstance") @Nullable String targetInstance, @ApiParam(value="Whether to reset only segments with error state") @QueryParam(value="errorSegmentsOnly") @DefaultValue(value="false") boolean errorSegmentsOnly) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        try {
            Preconditions.checkState((tableType != null ? 1 : 0) != 0, (String)"Must provide table name with type: %s", (Object)tableNameWithType);
            this._pinotHelixResourceManager.resetSegments(tableNameWithType, targetInstance, errorSegmentsOnly);
            return new SuccessResponse(String.format("Successfully reset segments of table: %s", tableNameWithType));
        }
        catch (IllegalStateException e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to reset segments in table: %s. %s", tableNameWithType, e.getMessage()), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += ((Integer)this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName, false).getLeft()).intValue();
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadSegmentDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @GET
    @Path(value="segments/segmentReloadStatus/{jobId}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetSegmentReloadStatus")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get status for a submitted reload operation", notes="Get status for a submitted reload operation")
    public ServerReloadControllerJobStatusResponse getReloadJobStatus(@ApiParam(value="Reload job id", required=true) @PathParam(value="jobId") String reloadJobId) throws Exception {
        Map<Object, Object> serverToSegments;
        Map<String, String> controllerJobZKMetadata = this._pinotHelixResourceManager.getControllerJobZKMetadata(reloadJobId, ControllerJobType.RELOAD_SEGMENT);
        if (controllerJobZKMetadata == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find controller job id: " + reloadJobId, Response.Status.NOT_FOUND);
        }
        String tableNameWithType = controllerJobZKMetadata.get("tableName");
        String singleSegmentName = controllerJobZKMetadata.get("segmentName");
        if (singleSegmentName != null) {
            serverToSegments = new HashMap();
            List<String> segmentList = Arrays.asList(singleSegmentName);
            this._pinotHelixResourceManager.getServers(tableNameWithType, singleSegmentName).forEach(server -> serverToSegments.put(server, segmentList));
        } else {
            serverToSegments = this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
        }
        BiMap<String, String> serverEndPoints = this._pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, serverEndPoints);
        ArrayList<String> serverUrls = new ArrayList<String>();
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String reloadTaskStatusEndpoint = endpoint + "/controllerJob/reloadStatus/" + tableNameWithType + "?reloadJobTimestamp=" + controllerJobZKMetadata.get("submissionTimeMs");
            if (singleSegmentName != null) {
                reloadTaskStatusEndpoint = reloadTaskStatusEndpoint + "&segmentName=" + singleSegmentName;
            }
            serverUrls.add(reloadTaskStatusEndpoint);
        }
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, null, true, 10000);
        ServerReloadControllerJobStatusResponse serverReloadControllerJobStatusResponse = new ServerReloadControllerJobStatusResponse();
        serverReloadControllerJobStatusResponse.setSuccessCount(0);
        int totalSegments = 0;
        for (Map.Entry<Object, Object> entry : serverToSegments.entrySet()) {
            totalSegments += ((List)entry.getValue()).size();
        }
        serverReloadControllerJobStatusResponse.setTotalSegmentCount(totalSegments);
        serverReloadControllerJobStatusResponse.setTotalServersQueried(serverUrls.size());
        serverReloadControllerJobStatusResponse.setTotalServerCallsFailed(serviceResponse._failedResponseCount);
        for (Map.Entry<Object, Object> entry : serviceResponse._httpResponses.entrySet()) {
            String responseString = (String)entry.getValue();
            try {
                ServerReloadControllerJobStatusResponse response = (ServerReloadControllerJobStatusResponse)JsonUtils.stringToObject((String)responseString, ServerReloadControllerJobStatusResponse.class);
                serverReloadControllerJobStatusResponse.setSuccessCount(serverReloadControllerJobStatusResponse.getSuccessCount() + response.getSuccessCount());
            }
            catch (Exception e) {
                serverReloadControllerJobStatusResponse.setTotalServerCallsFailed(serverReloadControllerJobStatusResponse.getTotalServerCallsFailed() + 1);
            }
        }
        serverReloadControllerJobStatusResponse.setMetadata(controllerJobZKMetadata);
        long submissionTime = Long.parseLong(controllerJobZKMetadata.get("submissionTimeMs"));
        double timeElapsedInMinutes = ((double)System.currentTimeMillis() - (double)submissionTime) / 60000.0;
        int remainingSegments = serverReloadControllerJobStatusResponse.getTotalSegmentCount() - serverReloadControllerJobStatusResponse.getSuccessCount();
        double estimatedRemainingTimeInMinutes = -1.0;
        if (serverReloadControllerJobStatusResponse.getSuccessCount() > 0) {
            estimatedRemainingTimeInMinutes = (double)remainingSegments / (double)serverReloadControllerJobStatusResponse.getSuccessCount() * timeElapsedInMinutes;
        }
        serverReloadControllerJobStatusResponse.setTimeElapsedInMinutes(timeElapsedInMinutes);
        serverReloadControllerJobStatusResponse.setEstimatedTimeRemainingInMinutes(estimatedRemainingTimeInMinutes);
        return serverReloadControllerJobStatusResponse;
    }

    @POST
    @Path(value="segments/{tableName}/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments", notes="Reload all segments")
    public SuccessResponse reloadAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to force server to download segment") @QueryParam(value="forceDownload") @DefaultValue(value="false") boolean forceDownload) throws JsonProcessingException {
        TableType tableTypeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        TableType tableTypeFromRequest = Constants.validateTableType(tableTypeStr);
        if (forceDownload && tableTypeFromTableName == null && tableTypeFromRequest == null) {
            tableTypeFromRequest = TableType.OFFLINE;
        }
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableTypeFromRequest, LOGGER);
        LinkedHashMap perTableMsgData = new LinkedHashMap();
        for (String tableNameWithType : tableNamesWithType) {
            Pair<Integer, String> msgInfo = this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType, forceDownload);
            HashMap<String, String> tableReloadMeta = new HashMap<String, String>();
            tableReloadMeta.put("numMessagesSent", String.valueOf(msgInfo.getLeft()));
            tableReloadMeta.put("reloadJobId", (String)msgInfo.getRight());
            perTableMsgData.put(tableNameWithType, tableReloadMeta);
            try {
                if (this._pinotHelixResourceManager.addNewReloadAllSegmentsJob(tableNameWithType, (String)msgInfo.getRight(), (Integer)msgInfo.getLeft())) {
                    tableReloadMeta.put("reloadJobMetaZKStorageStatus", "SUCCESS");
                    continue;
                }
                tableReloadMeta.put("reloadJobMetaZKStorageStatus", "FAILED");
                LOGGER.error("Failed to add reload all segments job meta into zookeeper for table: {}", (Object)tableNameWithType);
            }
            catch (Exception e) {
                tableReloadMeta.put("reloadJobMetaZKStorageStatus", "FAILED");
                LOGGER.error("Failed to add reload all segments job meta into zookeeper for table: {}", (Object)tableNameWithType, (Object)e);
            }
        }
        return new SuccessResponse("Segment reload details: " + JsonUtils.objectToString(perTableMsgData));
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += ((Integer)this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType, false).getLeft()).intValue();
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/reload")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReloadSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadAllSegmentsDeprecated1(tableName, tableTypeStr);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/{segmentName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteSegment")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete a segment", notes="Delete a segment")
    public SuccessResponse deleteSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="Retention period for the table segments (e.g. 12h, 3d); If not set, the retention period will default to the first config that's not null: the table config, then to cluster setting, then '7d'. Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        segmentName = URIUtils.decode((String)segmentName);
        String tableNameWithType = this.getExistingTable(tableName, segmentName);
        this.deleteSegmentsInternal(tableNameWithType, Collections.singletonList(segmentName), retentionPeriod);
        return new SuccessResponse("Segment deleted");
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteSegment")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete all segments", notes="Delete all segments")
    public SuccessResponse deleteAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Retention period for the table segments (e.g. 12h, 3d); If not set, the retention period will default to the first config that's not null: the table config, then to cluster setting, then '7d'. Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type must not be null", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        this.deleteSegmentsInternal(tableNameWithType, this._pinotHelixResourceManager.getSegmentsFromPropertyStore(tableNameWithType), retentionPeriod);
        return new SuccessResponse("All segments of table " + tableNameWithType + " deleted");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/delete")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DeleteSegment")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete the segments in the JSON array payload", notes="Delete the segments in the JSON array payload")
    public SuccessResponse deleteSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Retention period for the table segments (e.g. 12h, 3d); If not set, the retention period will default to the first config that's not null: the table config, then to cluster setting, then '7d'. Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod, List<String> segments) {
        int numSegments = segments.size();
        if (numSegments == 0) {
            throw new ControllerApplicationException(LOGGER, "Segments must be provided", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = this.getExistingTable(tableName, segments.get(0));
        this.deleteSegmentsInternal(tableNameWithType, segments, retentionPeriod);
        if (numSegments <= 5) {
            return new SuccessResponse("Deleted segments: " + segments + " from table: " + tableNameWithType);
        }
        return new SuccessResponse("Deleted " + numSegments + " segments from table: " + tableNameWithType);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/choose")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete selected segments. An optional 'excludeReplacedSegments' parameter is used to get the list of segments which has not yet been replaced (determined by segment lineage entries) and can be queried from the table. The value is false by default.", notes="List all segments")
    public SuccessResponse deleteSegmentsWithTimeWindow(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to ignore replaced segments for deletion, which have been replaced specified in the segment lineage entries and cannot be queried from the table, false by default") @QueryParam(value="excludeReplacedSegments") @DefaultValue(value="false") boolean excludeReplacedSegments, @ApiParam(value="Start timestamp (inclusive) in milliseconds", required=true) @QueryParam(value="startTimestamp") String startTimestampStr, @ApiParam(value="End timestamp (exclusive) in milliseconds", required=true) @QueryParam(value="endTimestamp") String endTimestampStr, @ApiParam(value="Whether to ignore segments that are partially overlapping with the [start, end)for deletion, true by default") @QueryParam(value="excludeOverlapping") @DefaultValue(value="true") boolean excludeOverlapping, @ApiParam(value="Retention period for the table segments (e.g. 12h, 3d); If not set, the retention period will default to the first config that's not null: the table config, then to cluster setting, then '7d'. Using 0d or -1d will instantly delete segments without retention") @QueryParam(value="retention") String retentionPeriod) {
        if (Strings.isNullOrEmpty((String)startTimestampStr) || Strings.isNullOrEmpty((String)endTimestampStr)) {
            throw new ControllerApplicationException(LOGGER, "start and end timestamp must by non empty", Response.Status.BAD_REQUEST);
        }
        int numSegments = 0;
        for (Pair<TableType, List<String>> tableTypeSegments : this.selectSegments(tableName, tableTypeStr, excludeReplacedSegments, startTimestampStr, endTimestampStr, excludeOverlapping)) {
            TableType tableType = (TableType)tableTypeSegments.getLeft();
            List segments = (List)tableTypeSegments.getRight();
            numSegments += segments.size();
            if (segments.isEmpty()) continue;
            String tableNameWithType = TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
            this.deleteSegmentsInternal(tableNameWithType, segments, retentionPeriod);
        }
        return new SuccessResponse("Deleted " + numSegments + " segments from table: " + tableName);
    }

    private void deleteSegmentsInternal(String tableNameWithType, List<String> segments, String retentionPeriod) {
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.deleteSegments(tableNameWithType, segments, retentionPeriod);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failed to delete segments from table: " + tableNameWithType + ", error message: " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="segments/{tableName}/metadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the server metadata for all table segments", notes="Get the server metadata for all table segments")
    public String getServerMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Columns name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) {
        String segmentsMetadata;
        LOGGER.info("Received a request to fetch metadata for all segments for table {}", (Object)tableName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            JsonNode segmentsMetadataJson = this.getSegmentsMetadataFromServer(tableNameWithType, columns);
            segmentsMetadata = JsonUtils.objectToPrettyString((Object)segmentsMetadataJson);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IOException ioe) {
            throw new ControllerApplicationException(LOGGER, "Error parsing Pinot server response: " + ioe.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ioe);
        }
        return segmentsMetadata;
    }

    @GET
    @Path(value="segments/{tableName}/zkmetadata")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetMetadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the zookeeper metadata for all table segments", notes="Get the zookeeper metadata for all table segments")
    public Map<String, Map<String, String>> getZookeeperMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        LOGGER.info("Received a request to fetch zookeeper metadata for all segments for table {}", (Object)tableName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        HashMap<String, Map<String, String>> segmentToMetadataMap = new HashMap<String, Map<String, String>>();
        List<SegmentZKMetadata> segmentZKMetadataList = this._pinotHelixResourceManager.getSegmentsZKMetadata(tableNameWithType);
        for (SegmentZKMetadata segmentZKMetadata : segmentZKMetadataList) {
            segmentToMetadataMap.put(segmentZKMetadata.getSegmentName(), segmentZKMetadata.toMap());
        }
        return segmentToMetadataMap;
    }

    @GET
    @Path(value="segments/{tableName}/tiers")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetStorageTier")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get storage tier for all segments in the given table", notes="Get storage tier for all segments in the given table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    public TableTierReader.TableTierDetails getTableTiers(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr) {
        LOGGER.info("Received a request to get storage tier for all segments for table {}", (Object)tableName);
        return this.getTableTierInternal(tableName, null, tableTypeStr);
    }

    @GET
    @Path(value="segments/{tableName}/{segmentName}/tiers")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetStorageTier")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get storage tiers for the given segment", notes="Get storage tiers for the given segment")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table or segment not found")})
    public TableTierReader.TableTierDetails getSegmentTiers(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        LOGGER.info("Received a request to get storage tier for segment {} in table {}", (Object)segmentName, (Object)tableName);
        return this.getTableTierInternal(tableName, segmentName, tableTypeStr);
    }

    private TableTierReader.TableTierDetails getTableTierInternal(String tableName, @Nullable String segmentName, @Nullable String tableTypeStr) {
        TableTierReader.TableTierDetails tableTierDetails;
        TableType tableType = Constants.validateTableType(tableTypeStr);
        Preconditions.checkNotNull((Object)tableType, (Object)"Table type is required to get table tiers");
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        TableTierReader tableTierReader = new TableTierReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
        try {
            tableTierDetails = tableTierReader.getTableTierDetails(tableNameWithType, segmentName, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
        }
        catch (Throwable t) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to get tier info for segment: %s in table: %s of type: %s", segmentName, tableName, tableTypeStr), Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        if (segmentName != null && !tableTierDetails.getSegmentTiers().containsKey(segmentName)) {
            throw new ControllerApplicationException(LOGGER, String.format("Segment: %s is not found in table: %s of type: %s", segmentName, tableName, tableTypeStr), Response.Status.NOT_FOUND);
        }
        return tableTierDetails;
    }

    @Deprecated
    @GET
    @Path(value="segments/{tableName}/select")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetSegment")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the selected segments given the (inclusive) start and (exclusive) end timestamps in milliseconds. These timestamps will be compared against the minmax values of the time column in each segment. If the table is a refresh use case, the value of start and end timestamp is voided, since there is no time column for refresh use case; instead, the whole qualified segments will be returned. If no timestamps are provided, all the qualified segments will be returned. For the segments that partially belong to the time range, the boolean flag 'excludeOverlapping' is introduced in order for user to determine whether to exclude this kind of segments in the response.", notes="Get the selected segments given the start and end timestamps in milliseconds")
    public List<Map<TableType, List<String>>> getSelectedSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Start timestamp (inclusive) in milliseconds") @QueryParam(value="startTimestamp") @DefaultValue(value="") String startTimestampStr, @ApiParam(value="End timestamp (exclusive) in milliseconds") @QueryParam(value="endTimestamp") @DefaultValue(value="") String endTimestampStr, @ApiParam(value="Whether to exclude the segments overlapping with the timestamps, false by default") @QueryParam(value="excludeOverlapping") @DefaultValue(value="false") boolean excludeOverlapping) {
        long endTimestamp;
        long startTimestamp;
        try {
            startTimestamp = Strings.isNullOrEmpty((String)startTimestampStr) ? Long.MIN_VALUE : Long.parseLong(startTimestampStr);
            endTimestamp = Strings.isNullOrEmpty((String)endTimestampStr) ? Long.MAX_VALUE : Long.parseLong(endTimestampStr);
        }
        catch (NumberFormatException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to parse the start/end timestamp. Please make sure they are in 'millisSinceEpoch' format.", Response.Status.BAD_REQUEST, (Throwable)e);
        }
        Preconditions.checkArgument((startTimestamp < endTimestamp ? 1 : 0) != 0, (String)"The value of startTimestamp should be smaller than the one of endTimestamp. Start timestamp: %d. End timestamp: %d", (long)startTimestamp, (long)endTimestamp);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Map<TableType, List<String>>> resultList = new ArrayList<Map<TableType, List<String>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
            List<String> segments = this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType, true, startTimestamp, endTimestamp, excludeOverlapping);
            resultList.add(Collections.singletonMap(tableType, segments));
        }
        return resultList;
    }

    private JsonNode getSegmentsMetadataFromServer(String tableNameWithType, List<String> columns) throws InvalidConfigException, IOException {
        TableMetadataReader tableMetadataReader = new TableMetadataReader(this._executor, this._connectionManager, this._pinotHelixResourceManager);
        return tableMetadataReader.getSegmentsMetadata(tableNameWithType, columns, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
    }

    @POST
    @Path(value="/segments/{tableNameWithType}/updateZKTimeInterval")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateTimeInterval")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the start and end time of the segments based on latest schema", notes="Update the start and end time of the segments based on latest schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse updateTimeIntervalZK(@ApiParam(value="Table name with type", required=true, example="myTable_REALTIME") @PathParam(value="tableNameWithType") String tableNameWithType) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, String.format("Table type not provided with table name %s", tableNameWithType), Response.Status.BAD_REQUEST);
        }
        return this.updateZKTimeIntervalInternal(tableNameWithType);
    }

    private SuccessResponse updateZKTimeIntervalInternal(String tableNameWithType) {
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        if (tableConfig == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table config for table: " + tableNameWithType, Response.Status.NOT_FOUND);
        }
        Schema tableSchema = this._pinotHelixResourceManager.getTableSchema(tableNameWithType);
        if (tableSchema == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find schema for table: " + tableNameWithType, Response.Status.NOT_FOUND);
        }
        String timeColumn = tableConfig.getValidationConfig().getTimeColumnName();
        if (StringUtils.isEmpty((CharSequence)timeColumn)) {
            throw new ControllerApplicationException(LOGGER, "Failed to find time column for table : " + tableNameWithType, Response.Status.NOT_FOUND);
        }
        DateTimeFieldSpec timeColumnFieldSpec = tableSchema.getSpecForTimeColumn(timeColumn);
        if (timeColumnFieldSpec == null) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to find field spec for column: %s and table: %s", timeColumn, tableNameWithType), Response.Status.NOT_FOUND);
        }
        try {
            this._pinotHelixResourceManager.updateSegmentsZKTimeInterval(tableNameWithType, timeColumnFieldSpec);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update time interval zk metadata for table %s", tableNameWithType), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return new SuccessResponse("Successfully updated time interval zk metadata for table: " + tableNameWithType);
    }

    private List<Pair<TableType, List<String>>> selectSegments(String tableName, String tableTypeStr, boolean excludeReplacedSegments, String startTimestampStr, String endTimestampStr, boolean excludeOverlapping) {
        long endTimestamp;
        long startTimestamp;
        try {
            startTimestamp = Strings.isNullOrEmpty((String)startTimestampStr) ? Long.MIN_VALUE : Long.parseLong(startTimestampStr);
            endTimestamp = Strings.isNullOrEmpty((String)endTimestampStr) ? Long.MAX_VALUE : Long.parseLong(endTimestampStr);
        }
        catch (NumberFormatException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to parse the start/end timestamp. Please make sure they are in 'millisSinceEpoch' format.", Response.Status.BAD_REQUEST, (Throwable)e);
        }
        Preconditions.checkArgument((startTimestamp < endTimestamp ? 1 : 0) != 0, (String)"The value of startTimestamp should be smaller than the one of endTimestamp. Start timestamp: %d. End timestamp: %d", (long)startTimestamp, (long)endTimestamp);
        List<String> tableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, Constants.validateTableType(tableTypeStr), LOGGER);
        ArrayList<Pair<TableType, List<String>>> resultList = new ArrayList<Pair<TableType, List<String>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
            List<String> segments = this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType, excludeReplacedSegments, startTimestamp, endTimestamp, excludeOverlapping);
            resultList.add((Pair<TableType, List<String>>)Pair.of((Object)tableType, segments));
        }
        return resultList;
    }
}

