/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.core.periodictask.PeriodicTaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"PeriodicTask"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/periodictask")
public class PinotControllerPeriodicTaskRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotControllerPeriodicTaskRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    PeriodicTaskScheduler _periodicTaskScheduler;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/run")
    @Authorize(targetType=TargetType.CLUSTER, action="ExecuteTask")
    @ApiOperation(value="Run periodic task against table. If table name is missing, task will run against all tables.")
    public Response runPeriodicTask(@ApiParam(value="Periodic task name", required=true) @QueryParam(value="taskname") String periodicTaskName, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="OFFLINE | REALTIME") @QueryParam(value="type") String tableType) {
        if (!this._periodicTaskScheduler.hasTask(periodicTaskName)) {
            throw new WebApplicationException("Periodic task '" + periodicTaskName + "' not found.", Response.Status.NOT_FOUND);
        }
        if (tableName != null) {
            List<String> matchingTableNamesWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName = tableName.trim(), Constants.validateTableType(tableType), LOGGER);
            if (matchingTableNamesWithType.size() > 1) {
                throw new WebApplicationException("More than one table matches Table '" + tableName + "'. Matching names: " + matchingTableNamesWithType.toString());
            }
            tableName = matchingTableNamesWithType.get(0);
        }
        return Response.ok().entity((Object)this._pinotHelixResourceManager.invokeControllerPeriodicTask(tableName, periodicTaskName, null)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/names")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTask")
    @ApiOperation(value="Get comma-delimited list of all available periodic task names.")
    public List<String> getPeriodicTaskNames() {
        return this._periodicTaskScheduler.getTaskNames();
    }
}

