/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.resources.InvalidControllerConfigException;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerFilePathProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerFilePathProvider.class);
    private static final String FILE_UPLOAD_TEMP_DIR = "fileUploadTemp";
    private static final String UNTARRED_FILE_TEMP_DIR = "untarredFileTemp";
    private static final String FILE_DOWNLOAD_TEMP_DIR = "fileDownloadTemp";
    private static ControllerFilePathProvider _instance;
    private final URI _dataDirURI;
    private final File _fileUploadTempDir;
    private final File _untarredFileTempDir;
    private final File _fileDownloadTempDir;
    private final String _vip;

    public static void init(ControllerConf controllerConf) throws InvalidControllerConfigException {
        _instance = new ControllerFilePathProvider(controllerConf);
    }

    public static ControllerFilePathProvider getInstance() {
        Preconditions.checkState((_instance != null ? 1 : 0) != 0, (Object)"ControllerFilePathProvider has not been initialized");
        return _instance;
    }

    private ControllerFilePathProvider(ControllerConf controllerConf) throws InvalidControllerConfigException {
        String dataDir = controllerConf.getDataDir();
        try {
            File localTempDir;
            this._dataDirURI = URIUtils.getUri((String)dataDir);
            LOGGER.info("Data directory: {}", (Object)this._dataDirURI);
            PinotFS pinotFS = PinotFSFactory.create((String)this._dataDirURI.getScheme());
            if (pinotFS.exists(this._dataDirURI)) {
                Preconditions.checkState((boolean)pinotFS.isDirectory(this._dataDirURI), (String)"Data directory: %s must be a directory", (Object)this._dataDirURI);
            } else {
                Preconditions.checkState((boolean)pinotFS.mkdir(this._dataDirURI), (String)"Failed to create data directory: %s", (Object)this._dataDirURI);
            }
            String localTempDirPath = controllerConf.getLocalTempDir();
            if (localTempDirPath == null) {
                Preconditions.checkState((boolean)this._dataDirURI.getScheme().equalsIgnoreCase("file"), (String)"Local temporary directory is not configured, cannot use remote data directory: %s as local temporary directory", (Object)this._dataDirURI);
                localTempDir = new File(new File(this._dataDirURI), controllerConf.getControllerHost() + "_" + controllerConf.getControllerPort());
            } else {
                localTempDir = new File(localTempDirPath);
            }
            LOGGER.info("Local temporary directory: {}", (Object)localTempDir);
            this._fileUploadTempDir = new File(localTempDir, FILE_UPLOAD_TEMP_DIR);
            LOGGER.info("File upload temporary directory: {}", (Object)this._fileUploadTempDir);
            this.initDir(this._fileUploadTempDir);
            this._untarredFileTempDir = new File(localTempDir, UNTARRED_FILE_TEMP_DIR);
            LOGGER.info("Untarred file temporary directory: {}", (Object)this._untarredFileTempDir);
            this.initDir(this._untarredFileTempDir);
            this._fileDownloadTempDir = new File(localTempDir, FILE_DOWNLOAD_TEMP_DIR);
            LOGGER.info("File download temporary directory: {}", (Object)this._fileDownloadTempDir);
            this.initDir(this._fileDownloadTempDir);
            this._vip = controllerConf.generateVipUrl();
        }
        catch (Exception e) {
            throw new InvalidControllerConfigException("Caught exception while initializing file upload path provider", e);
        }
    }

    private void initDir(File dir) throws IOException {
        if (dir.exists()) {
            FileUtils.cleanDirectory((File)dir);
        } else {
            FileUtils.forceMkdir((File)dir);
        }
    }

    public String getVip() {
        return this._vip;
    }

    public URI getDataDirURI() {
        return this._dataDirURI;
    }

    public File getFileUploadTempDir() {
        return this._fileUploadTempDir;
    }

    public File getUntarredFileTempDir() {
        return this._untarredFileTempDir;
    }

    public File getFileDownloadTempDir() {
        return this._fileDownloadTempDir;
    }
}

