/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import javax.annotation.Nullable;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessControlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessControlUtils.class);

    private AccessControlUtils() {
    }

    public static void validatePermission(@Nullable String tableName, AccessType accessType, @Nullable HttpHeaders httpHeaders, @Nullable String endpointUrl, AccessControl accessControl) {
        String userMessage = AccessControlUtils.getUserMessage(tableName, accessType, endpointUrl);
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        try {
            if (rawTableName == null ? accessControl.hasAccess(accessType, httpHeaders, endpointUrl) : accessControl.hasAccess(rawTableName, accessType, httpHeaders, endpointUrl)) {
                return;
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught exception while validating permission for " + userMessage, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "Permission is denied for " + userMessage, Response.Status.FORBIDDEN);
    }

    private static String getUserMessage(String tableName, AccessType accessType, String endpointUrl) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return String.format("%s '%s'", new Object[]{accessType, endpointUrl});
        }
        return String.format("%s '%s' for table '%s'", new Object[]{accessType, endpointUrl, tableName});
    }
}

