/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AuthenticationFilter;
import org.apache.pinot.core.api.ServiceAutoDiscoveryFeature;
import org.apache.pinot.core.transport.ListenerConfig;
import org.apache.pinot.core.util.ListenerConfigUtil;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class ControllerAdminApiApplication
extends ResourceConfig {
    public static final String PINOT_CONFIGURATION = "pinotConfiguration";
    private final String _controllerResourcePackages;
    private final boolean _useHttps;
    private HttpServer _httpServer;

    public ControllerAdminApiApplication(ControllerConf conf) {
        this.property(PINOT_CONFIGURATION, (Object)conf);
        this._controllerResourcePackages = conf.getControllerResourcePackages();
        this.packages(new String[]{this._controllerResourcePackages});
        this._useHttps = Boolean.parseBoolean(conf.getProperty("controller.swagger.use.https"));
        if (conf.getProperty("pinot.controller.service.auto.discovery", false)) {
            this.register(ServiceAutoDiscoveryFeature.class);
        }
        this.register(JacksonFeature.class);
        this.register(MultiPartFeature.class);
        this.registerClasses(new Class[]{ApiListingResource.class});
        this.registerClasses(new Class[]{SwaggerSerializers.class});
        this.register(new CorsFilter());
        this.register(AuthenticationFilter.class);
    }

    public void registerBinder(AbstractBinder binder) {
        this.register(binder);
    }

    public void start(List<ListenerConfig> listenerConfigs) {
        this._httpServer = ListenerConfigUtil.buildHttpServer((ResourceConfig)this, listenerConfigs);
        try {
            this._httpServer.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start http server", e);
        }
        PinotReflectionUtils.runWithLock(this::setupSwagger);
        ClassLoader classLoader = ControllerAdminApiApplication.class.getClassLoader();
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/webapp/"}), new String[]{"/index.html"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/webapp/images/"}), new String[]{"/images/"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/webapp/js/"}), new String[]{"/js/"});
    }

    private void setupSwagger() {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Pinot Controller API");
        beanConfig.setDescription("APIs for accessing Pinot Controller information");
        beanConfig.setContact("https://github.com/apache/pinot");
        beanConfig.setVersion("1.0");
        beanConfig.setExpandSuperTypes(false);
        if (this._useHttps) {
            beanConfig.setSchemes(new String[]{"https"});
        } else {
            beanConfig.setSchemes(new String[]{"http", "https"});
        }
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage(this._controllerResourcePackages);
        beanConfig.setScan(true);
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        CLStaticHttpHandler apiStaticHttpHandler = new CLStaticHttpHandler(loader, new String[]{"/api/"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/api/"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/help/"});
        URL swaggerDistLocation = loader.getResource("META-INF/resources/webjars/swagger-ui/5.1.0/");
        CLStaticHttpHandler swaggerDist = new CLStaticHttpHandler((ClassLoader)new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }

    public void stop() {
        if (!this._httpServer.isStarted()) {
            return;
        }
        this._httpServer.shutdownNow();
    }

    private class CorsFilter
    implements ContainerResponseFilter {
        private CorsFilter() {
        }

        public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
            containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, OPTIONS, DELETE");
            containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"*");
            if (containerRequestContext.getMethod().equals("OPTIONS")) {
                containerResponseContext.setStatus(200);
            }
        }
    }
}

